/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AppEng;
import appeng.menu.AEBaseMenu;
import appeng.menu.interfaces.IProgressProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.widgets.QuantumUpgradeWidget;
import net.pedroksl.advanced_ae.client.widgets.UpgradeState;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorMagnetPacket;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeFilterPacket;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeValuePacket;
import net.pedroksl.ae2addonlib.client.Hotkeys;
import net.pedroksl.ae2addonlib.client.widgets.AddonIconButton;
import org.jetbrains.annotations.Nullable;

public class QuantumArmorConfigScreen
extends AEBaseScreen<QuantumArmorConfigMenu> {
    private static final int LIST_ANCHOR_X = 9;
    private static final int LIST_ANCHOR_Y = 31;
    private static final int LIST_LINE_HEIGHT = 16;
    private static final int VISIBLE_ROWS = 4;
    private static final Rect2i LIST_BACK_BBOX = new Rect2i(0, 195, 128, 16);
    private static final ResourceLocation DEFAULT_TEXTURE = AppEng.makeId((String)"textures/guis/quantum_armor_config.png");
    private final Scrollbar scrollbar;
    private final ProgressBar pb;
    private final PaletteButton paletteButton;
    private int selectedIndex = -1;
    private final List<QuantumUpgradeWidget> upgradeList = new ArrayList<QuantumUpgradeWidget>();

    public QuantumArmorConfigScreen(QuantumArmorConfigMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.SMALL);
        this.pb = new ProgressBar((IProgressProvider)menu, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.pb.f_93623_ = false;
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.paletteButton = new PaletteButton(btn -> ((QuantumArmorConfigMenu)this.m_6262_()).openStyleScreen());
        this.widgets.add("styleButton", (AbstractWidget)this.paletteButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshList(true);
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        Slot slot;
        assert (this.f_96541_ != null);
        if (btn == 0 && this.isArmorSlot(slot = this.m_97744_(xCoord, yCoord))) {
            this.selectedIndex = slot.f_40219_;
            ((QuantumArmorConfigMenu)this.f_97732_).setSelectedItemSlot(slot.getSlotIndex());
            this.refreshList(true);
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isCloseHotkey(keyCode, scanCode)) {
            this.getPlayer().m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean isCloseHotkey(int keyCode, int scanCode) {
        Hotkeys.AddonHotkey hotkey;
        String hotkeyId = ((QuantumArmorConfigMenu)this.m_6262_()).getHost().getCloseHotkey();
        if (hotkeyId != null && (hotkey = AAEHotkeys.INSTANCE.getHotkeyMapping(hotkeyId)) != null) {
            return hotkey.mapping().m_90832_(keyCode, scanCode);
        }
        return false;
    }

    private boolean isArmorSlot(Slot slot) {
        return slot != null && slot.m_6659_() && slot.m_6657_() && ((QuantumArmorConfigMenu)this.f_97732_).isArmorSlot(slot) && slot.m_7993_().m_41720_() instanceof QuantumArmorBase;
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int currentRow;
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        this.upgradeList.forEach(QuantumUpgradeWidget::hide);
        int visibleRows = Math.min(4, this.upgradeList.size());
        for (int i = 0; i < visibleRows && (currentRow = scrollLevel + i) < this.upgradeList.size(); ++i) {
            QuantumUpgradeWidget upgrade = this.upgradeList.get(currentRow);
            int y = 31 + i * 16;
            upgrade.setY(y, this.f_97736_);
            upgrade.show();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(10.0f, 8.0f + (float)i * 3.5f, 0.0f);
            poseStack.m_85841_(0.8f, 0.8f, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, upgrade.getType().getTranslatedName(), upgrade.getX() + 2, upgrade.getY() + 3, color.toARGB(), false);
            poseStack.m_85849_();
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        int currentX = offsetX + 9;
        int currentY = offsetY + 31 - 1;
        int visibleRows = Math.min(4, this.upgradeList.size());
        for (int i = 0; i < visibleRows; ++i) {
            guiGraphics.m_280218_(DEFAULT_TEXTURE, currentX, currentY, LIST_BACK_BBOX.m_110085_(), LIST_BACK_BBOX.m_110086_(), LIST_BACK_BBOX.m_110090_(), LIST_BACK_BBOX.m_110091_());
            currentY += 16;
        }
        if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorConfigMenu)this.f_97732_).f_38839_.size()) {
            Slot slot = ((QuantumArmorConfigMenu)this.f_97732_).m_38853_(this.selectedIndex);
            AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.f_40220_ + offsetX), (int)(slot.f_40221_ + offsetY), (int)0, (int)2021479361);
        }
    }

    public void refreshList(int selectedIndex, ItemStack stack) {
        this.selectedIndex = selectedIndex;
        this.getPlayer().m_8061_(((QuantumArmorBase)stack.m_41720_()).m_40402_(), stack);
        this.refreshList(stack, false);
    }

    public void refreshList(boolean removeWidgets) {
        this.refreshList(ItemStack.f_41583_, removeWidgets);
    }

    public void refreshList(@Nullable ItemStack stack, boolean removeWidgets) {
        if (stack == null) {
            ((QuantumArmorConfigMenu)this.f_97732_).updateClient();
            return;
        }
        if (removeWidgets) {
            this.upgradeList.forEach(w -> w.children().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0)));
            this.upgradeList.clear();
        }
        if (stack.m_41619_() && (this.selectedIndex == -1 || this.selectedIndex > ((QuantumArmorConfigMenu)this.f_97732_).f_38839_.size())) {
            return;
        }
        int index = 0;
        ItemStack armorStack = stack.m_41619_() ? ((QuantumArmorConfigMenu)this.f_97732_).m_38853_(this.selectedIndex).m_7993_() : stack;
        Item item = armorStack.m_41720_();
        if (item instanceof QuantumArmorBase) {
            QuantumArmorBase item2 = (QuantumArmorBase)item;
            block0: for (UpgradeType upgrade : item2.getPossibleUpgrades()) {
                if (item2.hasUpgrade(armorStack, upgrade)) {
                    boolean enabled = item2.isUpgradeEnabled(armorStack, upgrade);
                    int value = item2.getUpgradeValue(armorStack, upgrade, 1);
                    List filter = item2.getFilter(armorStack, upgrade);
                    UpgradeState state = new UpgradeState(upgrade, upgrade.getSettings(), enabled, value, filter);
                    boolean found = false;
                    for (QuantumUpgradeWidget widget : this.upgradeList) {
                        if (widget.getType() != upgrade) continue;
                        widget.setState(state);
                        found = true;
                    }
                    if (!found) {
                        QuantumUpgradeWidget widget = new QuantumUpgradeWidget(this, index, 9, 31 + index * 16, this.style, state);
                        widget.add();
                        this.upgradeList.add(widget);
                    }
                    ++index;
                    continue;
                }
                if (removeWidgets) continue;
                for (QuantumUpgradeWidget w2 : this.upgradeList) {
                    if (w2.getType() != upgrade) continue;
                    w2.children().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
                    this.upgradeList.remove(w2);
                    continue block0;
                }
            }
        }
        this.resetScrollbar();
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((QuantumArmorConfigMenu)this.f_97732_).getCurrentProgress() * 100 / ((QuantumArmorConfigMenu)this.f_97732_).getMaxProgress();
        if (progress >= 0) {
            this.pb.setFullMsg((Component)Component.m_237113_((String)(progress + "%")));
        } else {
            this.pb.setFullMsg((Component)Component.m_237113_((String)""));
        }
    }

    public void addChildWidget(String id, AbstractWidget widget, Map<String, AbstractWidget> child) {
        if (widget.m_93696_()) {
            widget.m_93692_(false);
        }
        widget.m_252865_(widget.m_252754_() + this.f_97735_);
        widget.m_253211_(widget.m_252907_() + this.f_97736_);
        child.put(id, widget);
        this.m_142416_((GuiEventListener)widget);
    }

    public void requestUninstall(UpgradeType upgradeType) {
        ((QuantumArmorConfigMenu)this.f_97732_).requestUninstall(upgradeType);
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(62);
        this.scrollbar.setRange(0, this.upgradeList.size() - 4, 1);
    }

    public void m_7379_() {
        ((QuantumArmorConfigMenu)this.f_97732_).emptyUpgradeSlot();
        super.m_7379_();
    }

    public void openConfigDialog(UpgradeState state) {
        ItemStack stack;
        Item item;
        if (state.type().getSettingType() == UpgradeType.SettingType.NUM_INPUT) {
            AAENetworkHandler.INSTANCE.sendToServer(new QuantumArmorUpgradeValuePacket(state.type(), state.currentValue()));
        } else if (state.type().getSettingType() == UpgradeType.SettingType.FILTER) {
            AAENetworkHandler.INSTANCE.sendToServer(new QuantumArmorUpgradeFilterPacket(state.type(), state.filter()));
        } else if (state.type().getSettingType() == UpgradeType.SettingType.NUM_AND_FILTER && state.type() == UpgradeType.MAGNET && (item = (stack = ((QuantumArmorConfigMenu)this.f_97732_).m_38853_(this.selectedIndex).m_7993_()).m_41720_()) instanceof QuantumArmorBase) {
            QuantumArmorBase item2 = (QuantumArmorBase)item;
            boolean blacklist = item2.isUpgradeEnabled(stack, UpgradeType.MAGNET);
            AAENetworkHandler.INSTANCE.sendToServer(new QuantumArmorMagnetPacket(state.currentValue(), state.filter(), blacklist));
        }
    }

    static class PaletteButton
    extends AddonIconButton {
        public PaletteButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected AAEIcon getIcon() {
            return this.m_198029_() ? AAEIcon.PALETTE : AAEIcon.PALETTE_DISABLED;
        }
    }
}

