/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.pedroksl.ae2addonlib.registry.ConfigRegistry;

@Mod.EventBusSubscriber(modid="advanced_ae", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AAEConfig
extends ConfigRegistry {
    private final ClientConfig client = new ClientConfig();
    private final CommonConfig common = new CommonConfig();
    private static AAEConfig INSTANCE;

    AAEConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.client.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.common.spec);
    }

    public boolean getEnableEffects() {
        return (Boolean)this.client.enableEffects.get();
    }

    public int getQuantumComputerMaxSize() {
        return (Integer)this.common.quantumComputerMaxSize.get();
    }

    public int getQuantumComputerAcceleratorThreads() {
        return (Integer)this.common.quantumComputerAcceleratorThreads.get();
    }

    public int getQuantumComputerMaxMultiThreaders() {
        return (Integer)this.common.quantumComputerMaxMultiThreaders.get();
    }

    public int getQuantumComputermaxDataEntanglers() {
        return (Integer)this.common.quantumComputerMaxDataEntanglers.get();
    }

    public int getQuantumComputerMultiThreaderMultiplication() {
        return (Integer)this.common.quantumComputerMultiThreaderMultiplication.get();
    }

    public int getQuantumComputerDataEntanglerMultiplication() {
        return (Integer)this.common.quantumComputerDataEntanglerMultiplication.get();
    }

    public int getMaxWalkSpeed() {
        return (Integer)this.common.maxWalkSpeed.get();
    }

    public int getMaxSprintSpeed() {
        return (Integer)this.common.maxSprintSpeed.get();
    }

    public int getMaxStepHeight() {
        return (Integer)this.common.maxStepHeight.get();
    }

    public int getMaxJumpHeight() {
        return (Integer)this.common.maxJumpHeight.get();
    }

    public int getmaxHpBuffer() {
        return (Integer)this.common.hpBufferHearts.get();
    }

    public int getMaxFlightSpeed() {
        return (Integer)this.common.maxFlightSpeed.get();
    }

    public int getEvasionChance() {
        return (Integer)this.common.evasionChance.get();
    }

    public int getMaxMagnetRange() {
        return (Integer)this.common.maxMagnetRange.get();
    }

    public int getStrengthBoost() {
        return (Integer)this.common.strengthBoost.get();
    }

    public int getAttackSpeedBoost() {
        return (Integer)this.common.attackSpeedBoost.get();
    }

    public int getLuckBoost() {
        return (Integer)this.common.luckBoost.get();
    }

    public int getMaxReachBoost() {
        return (Integer)this.common.maxReachBoost.get();
    }

    public int getMaxSwimSpeedBoost() {
        return (Integer)this.common.swimSpeedBoost.get();
    }

    public int getRenegerationPerTick() {
        return (Integer)this.common.regenerationPerTick.get();
    }

    public int getPercentageDamageAbsorption() {
        return (Integer)this.common.percentageDamageAbsorption.get();
    }

    public int getThroughputMonitorCacheSize() {
        return (Integer)this.common.throughputMonitorCacheSize.get();
    }

    public void save() {
        this.common.spec.save();
        this.client.spec.save();
    }

    public static void register(String mod_id) {
        if (!mod_id.equals("advanced_ae")) {
            throw new IllegalArgumentException();
        }
        INSTANCE = new AAEConfig();
    }

    public static AAEConfig instance() {
        return INSTANCE;
    }

    private static class ClientConfig {
        private final ForgeConfigSpec spec;
        public final ForgeConfigSpec.BooleanValue enableEffects;

        public ClientConfig() {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("reaction chamber");
            this.enableEffects = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"enableEffects", (boolean)true, (String)"Enable/disable reaction chamber's item rendering. Saves on performance if there are a considerable amount of them running at the same time.");
            this.spec = builder.build();
        }
    }

    private static class CommonConfig {
        private final ForgeConfigSpec spec;
        public final ForgeConfigSpec.IntValue quantumComputerMaxSize;
        public final ForgeConfigSpec.IntValue quantumComputerAcceleratorThreads;
        public final ForgeConfigSpec.IntValue quantumComputerMaxMultiThreaders;
        public final ForgeConfigSpec.IntValue quantumComputerMaxDataEntanglers;
        public final ForgeConfigSpec.IntValue quantumComputerMultiThreaderMultiplication;
        public final ForgeConfigSpec.IntValue quantumComputerDataEntanglerMultiplication;
        public final ForgeConfigSpec.IntValue maxWalkSpeed;
        public final ForgeConfigSpec.IntValue maxSprintSpeed;
        public final ForgeConfigSpec.IntValue maxStepHeight;
        public final ForgeConfigSpec.IntValue maxJumpHeight;
        public final ForgeConfigSpec.IntValue hpBufferHearts;
        public final ForgeConfigSpec.IntValue maxFlightSpeed;
        public final ForgeConfigSpec.IntValue evasionChance;
        public final ForgeConfigSpec.IntValue maxMagnetRange;
        public final ForgeConfigSpec.IntValue strengthBoost;
        public final ForgeConfigSpec.IntValue attackSpeedBoost;
        public final ForgeConfigSpec.IntValue luckBoost;
        public final ForgeConfigSpec.IntValue maxReachBoost;
        public final ForgeConfigSpec.IntValue swimSpeedBoost;
        public final ForgeConfigSpec.IntValue regenerationPerTick;
        public final ForgeConfigSpec.IntValue percentageDamageAbsorption;
        public final ForgeConfigSpec.IntValue throughputMonitorCacheSize;

        public CommonConfig() {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("quantum computer");
            this.quantumComputerMaxSize = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputerMaxSize", (int)7, (int)5, (int)12, (String)"Define the maximum dimensions of the Quantum Computer Multiblock.");
            this.quantumComputerAcceleratorThreads = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputerAcceleratorThreads", (int)8, (int)4, (int)16, (String)"Define the amount of Threads per Quantum Computer Accelerator.");
            this.quantumComputerMaxMultiThreaders = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputerMaxMultiThreaders", (int)1, (int)1, (int)2, (String)"Define the maximum amount of multi threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxDataEntanglers = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputermaxDataEntanglers", (int)1, (int)1, (int)2, (String)"Define the maximum amount of Data Entanglers per Quantum Computer Multiblock.");
            this.quantumComputerMultiThreaderMultiplication = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputerMultiThreaderMultiplication", (int)4, (int)2, (int)8, (String)"Define the multiplication factor of the multi threaders.");
            this.quantumComputerDataEntanglerMultiplication = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumComputerDataEntanglerMultiplication", (int)4, (int)2, (int)8, (String)"Define the multiplication factor of the data entanglers.");
            builder.pop();
            builder.push("quantum armor");
            this.maxWalkSpeed = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxWalkSpeed", (int)60, (int)10, (int)100, (String)"Define the maximum walk speed increase. Values are divided by 10 before use.");
            this.maxSprintSpeed = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxSprintSpeed", (int)80, (int)10, (int)150, (String)"Define the maximum sprint speed increase. Values are divided by 10 before use.");
            this.maxStepHeight = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxStepHeight", (int)3, (int)1, (int)5, (String)"Define the maximum increase in step height.");
            this.maxJumpHeight = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxJumpHeight", (int)3, (int)1, (int)5, (String)"Define the maximum increase in jump height.");
            this.swimSpeedBoost = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorSwimSpeedBoost", (int)80, (int)10, (int)150, (String)"Define the maximum swim speed increase. Values are divided by 10 before use.");
            this.hpBufferHearts = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorHpBuffer", (int)20, (int)5, (int)50, (String)"Define the HP increased of the HP Buffer card.");
            this.maxFlightSpeed = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxFlightSpeed", (int)10, (int)1, (int)15, (String)"Define the maximum speed boost of the Flight Card.");
            this.evasionChance = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorEvasionChance", (int)30, (int)0, (int)100, (String)"Define the evasion % chance of the evasion card.");
            this.maxMagnetRange = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMagnetRange", (int)12, (int)5, (int)15, (String)"Define the max range of the magnet card.");
            this.strengthBoost = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorStrengthBoost", (int)10, (int)5, (int)50, (String)"Define the Attack Damage boost of the Strength Card.");
            this.attackSpeedBoost = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorAttackSpeedBoost", (int)5, (int)1, (int)10, (String)"Define the Attack Speed Damage boost of the Attack Speed Card.");
            this.luckBoost = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorLuckBoost", (int)2, (int)1, (int)5, (String)"Define the luck boost of the Luck Card.");
            this.maxReachBoost = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorMaxReachBoost", (int)5, (int)1, (int)8, (String)"Define the max additional reach of the Reach Card.");
            this.regenerationPerTick = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorRenegerationPerTick", (int)10, (int)1, (int)20, (String)"Define the amount of hearts regenerated per tick with the Regeneration Card. Value will be divided by 10 before use.");
            this.percentageDamageAbsorption = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"quantumArmorPercentageDamageAbsorption", (int)30, (int)5, (int)100, (String)"Define the maximum percentage of incoming damage absorbed by the Quantum Armor. This value is still limited by the energy buffer in the equipment.");
            builder.pop();
            builder.push("Miscellaneous");
            this.throughputMonitorCacheSize = AAEConfig.define((ForgeConfigSpec.Builder)builder, (String)"throughputMonitorCacheSize", (int)80, (int)40, (int)400, (String)"Define the size of the cache for the Throughput Monitor. Only affects \"Per minute\" and \"Per 10 minutes\" configurations. Higher values will increase precison, but will make the monitor react slower to changes.");
            builder.pop();
            this.spec = builder.build();
        }
    }
}

