/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.LibBlockDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.LibItemDefinition;
import org.jetbrains.annotations.NotNull;

public class AAELanguageProvider
extends LanguageProvider {
    public AAELanguageProvider(PackOutput output) {
        super(output, "advanced_ae", "en_us");
    }

    protected void addTranslations() {
        for (LibItemDefinition item : AAEItems.INSTANCE.getItems()) {
            this.add(item.m_5456_(), item.getEnglishName());
        }
        for (LibBlockDefinition block : AAEBlocks.INSTANCE.getBlocks()) {
            this.add(block.block(), block.getEnglishName());
        }
        for (FluidDefinition fluid : AAEFluids.INSTANCE.getFluids()) {
            this.add(fluid.fluidType(), fluid.englishName());
            this.add(fluid.flowing(), fluid.englishName());
            this.add(fluid.source(), fluid.englishName());
            this.add((Block)fluid.block(), fluid.englishName());
            this.add((Item)fluid.bucketItem(), fluid.bucketItemId().getEnglishName());
        }
        for (AAEText aAEText : AAEText.values()) {
            this.add(aAEText.getTranslationKey(), aAEText.getEnglishText());
        }
        for (Enum enum_ : AAEHotkeysRegistry.Keys.values()) {
            this.add("key.advanced_ae." + ((AAEHotkeysRegistry.Keys)enum_).getId(), ((AAEHotkeysRegistry.Keys)enum_).getEnglishTranslation());
        }
        for (Enum enum_ : UpgradeType.values()) {
            this.add(((UpgradeType)enum_).getTranslationKey(), ((UpgradeType)enum_).name);
        }
        this.generateLocalizations();
    }

    private void generateLocalizations() {
        this.add("key.advanced_ae.category", "Advanced AE");
        this.add("key.ae2.wireless_quantum_crafter_terminal", "Open Wireless Quantum Crafter Terminal");
        this.add("curios.identifier.adv_pattern_encoder", "Pattern Encoder");
    }

    public void add(FluidType key, String englishName) {
        this.add(Util.m_137492_((String)"fluid_type", (ResourceLocation)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)key)), englishName);
    }

    public void add(Fluid key, String englishName) {
        this.add(Util.m_137492_((String)"fluid", (ResourceLocation)BuiltInRegistries.f_257020_.m_7981_((Object)key)), englishName);
    }

    @NotNull
    public String m_6055_() {
        return "Language";
    }
}

