/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;
import org.jetbrains.annotations.Nullable;

public final class ReactionChamberRecipes {
    private ReactionChamberRecipes() {
    }

    public static Iterable<ReactionChamberRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44054_(ReactionChamberRecipe.TYPE).values();
    }

    @Nullable
    public static ReactionChamberRecipe findRecipe(Level level, List<ItemStack> inputs, GenericStack fluid) {
        ArrayList<ItemStack> machineInputs = new ArrayList<ItemStack>();
        for (ItemStack stack : inputs) {
            if (stack.m_41619_()) continue;
            machineInputs.add(stack);
        }
        for (ReactionChamberRecipe recipe : ReactionChamberRecipes.getRecipes(level)) {
            List<IngredientStack<?, ?>> validInputs = recipe.getValidInputs();
            boolean failed = false;
            for (IngredientStack<?, ?> input : validInputs) {
                boolean found = false;
                for (ItemStack machineInput : machineInputs) {
                    if (!input.checkType((Object)machineInput) || !((IngredientStack.Item)input).test(machineInput) || input.getAmount() > machineInput.m_41613_()) continue;
                    found = true;
                    break;
                }
                if (input instanceof IngredientStack.Fluid) {
                    AEFluidKey key;
                    FluidStack fluidStack;
                    AEKey aEKey;
                    IngredientStack.Fluid fluidIn = (IngredientStack.Fluid)input;
                    if (fluid != null && (aEKey = fluid.what()) instanceof AEFluidKey && fluidIn.test(fluidStack = (key = (AEFluidKey)aEKey).toStack((int)fluid.amount())) && (long)input.getAmount() <= fluid.amount()) {
                        found = true;
                    }
                }
                if (found) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack stack, Level level) {
        for (ReactionChamberRecipe recipe : ReactionChamberRecipes.getRecipes(level)) {
            if (!recipe.containsIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidIngredient(FluidStack stack, Level level) {
        for (ReactionChamberRecipe recipe : ReactionChamberRecipes.getRecipes(level)) {
            if (!recipe.containsIngredient(stack)) continue;
            return true;
        }
        return false;
    }
}

