/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.Tooltips;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.ReactionChamberMenu;
import net.pedroksl.ae2addonlib.api.IFluidTankScreen;
import net.pedroksl.ae2addonlib.client.widgets.AddonActionButton;
import net.pedroksl.ae2addonlib.client.widgets.AddonActionItems;
import net.pedroksl.ae2addonlib.client.widgets.FluidTankSlot;
import net.pedroksl.ae2addonlib.client.widgets.IActionEnum;
import net.pedroksl.ae2addonlib.client.widgets.ToolbarActionButton;

public class ReactionChamberScreen
extends UpgradeableScreen<ReactionChamberMenu>
implements IFluidTankScreen {
    private static final int INPUT_TANK_X = 9;
    private static final int OUTPUT_TANK_X = 151;
    private static final int TANKS_Y = 21;
    private static final int TANKS_WIDTH = 16;
    private static final int TANKS_HEIGHT = 58;
    private final ProgressBar pb;
    private final SettingToggleButton<YesNo> autoExportBtn;
    private final ToolbarActionButton outputConfigure;
    private final AlertWidget powerAlert;
    private FluidTankSlot inputSlot;
    private FluidTankSlot outputSlot;

    public ReactionChamberScreen(ReactionChamberMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.pb = new ProgressBar((IProgressProvider)this.menu, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.autoExportBtn = new ServerSettingToggleButton(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.addToLeftToolbar((Button)this.autoExportBtn);
        this.outputConfigure = new ToolbarActionButton((IActionEnum)AddonActionItems.DIRECTIONAL_OUTPUT, btn -> menu.configureOutput());
        this.outputConfigure.setVisibility(((ReactionChamberMenu)this.getMenu()).getAutoExport() == YesNo.YES);
        this.addToLeftToolbar((Button)this.outputConfigure);
        AddonActionButton clearBtn = new AddonActionButton((IActionEnum)AddonActionItems.FLUID_FLUSH, btn -> menu.clearFluid());
        clearBtn.setHalfSize(true);
        clearBtn.setDisableBackground(true);
        this.widgets.add("clearFluid", (AbstractWidget)clearBtn);
        AddonActionButton clearOutBtn = new AddonActionButton((IActionEnum)AddonActionItems.FLUID_FLUSH, btn -> menu.clearFluidOut());
        clearOutBtn.setHalfSize(true);
        clearOutBtn.setDisableBackground(true);
        this.widgets.add("clearFluidOut", (AbstractWidget)clearOutBtn);
        this.powerAlert = new AlertWidget(style.getImage("powerAlert"));
        this.powerAlert.setTooltip(Tooltip.create((Component)Tooltips.of((Component[])new Component[]{AAEText.InsufficientPower.text().withStyle(Tooltips.RED), Component.literal((String)"\n").append((Component)AAEText.InsufficientPowerDetails.text()).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT)})));
        this.widgets.add("powerAlert", (AbstractWidget)this.powerAlert);
    }

    protected void init() {
        Objects.requireNonNull((ReactionChamberMenu)this.menu);
        this.inputSlot = (FluidTankSlot)this.addRenderableWidget((GuiEventListener)new FluidTankSlot((AbstractContainerScreen)this, 1, this.leftPos + 9, this.topPos + 21, 16, 58, 16, (Component)Component.empty()));
        Objects.requireNonNull((ReactionChamberMenu)this.menu);
        this.outputSlot = (FluidTankSlot)this.addRenderableWidget((GuiEventListener)new FluidTankSlot((AbstractContainerScreen)this, 0, this.leftPos + 151, this.topPos + 21, 16, 58, 16, (Component)Component.empty()));
        super.init();
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((ReactionChamberMenu)this.menu).getCurrentProgress() * 100 / ((ReactionChamberMenu)this.menu).getMaxProgress();
        this.pb.setFullMsg((Component)Component.literal((String)(progress + "%")));
        this.autoExportBtn.set((Enum)((ReactionChamberMenu)this.getMenu()).getAutoExport());
        this.outputConfigure.setVisibility(((ReactionChamberMenu)this.getMenu()).getAutoExport() == YesNo.YES);
        this.inputSlot.setPosition(this.leftPos + 9, this.topPos + 21);
        this.outputSlot.setPosition(this.leftPos + 151, this.topPos + 21);
        this.powerAlert.visible = ((ReactionChamberMenu)this.getMenu()).getShowWarning();
    }

    public void updateFluidTankContents(int index, FluidStack stack) {
        if (index == 1) {
            this.inputSlot.setFluidStack(stack);
        } else {
            this.outputSlot.setFluidStack(stack);
        }
    }

    public void playSoundFeedback(boolean isInsert) {
        this.inputSlot.playDownSound(Minecraft.getInstance().getSoundManager(), isInsert);
    }

    private static class AlertWidget
    extends AbstractWidget {
        private final Blitter powerAlert;

        public AlertWidget(Blitter powerAlert) {
            super(0, 0, 18, 18, (Component)Component.empty());
            this.powerAlert = powerAlert;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
            this.powerAlert.dest(this.getX(), this.getY()).blit(guiGraphics);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

