/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client;

import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.core.definitions.ItemDefinition;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvancedIOBusScreen;
import net.pedroksl.advanced_ae.client.gui.ImportExportBusScreen;
import net.pedroksl.advanced_ae.client.gui.PortableWorkbenchScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorFilterConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorMagnetScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorNumInputConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorStyleConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumComputerScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterConfigPatternScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterTermScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterWirelessTermScreen;
import net.pedroksl.advanced_ae.client.gui.ReactionChamberScreen;
import net.pedroksl.advanced_ae.client.gui.SmallAdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.StockExportBusScreen;
import net.pedroksl.advanced_ae.client.renderer.AAECraftingUnitModelProvider;
import net.pedroksl.advanced_ae.client.renderer.ReactionChamberTESR;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.ae2addonlib.registry.FluidRegistry;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.LibComponents;
import net.pedroksl.ae2addonlib.util.Colors;

@Mod(value="advanced_ae", dist={Dist.CLIENT})
public class AAEClient
extends AdvancedAE {
    private static AAEClient INSTANCE;

    public AAEClient(IEventBus eventBus, ModContainer container) {
        super(eventBus, container);
        AAEClient.initBuiltInModels();
        eventBus.addListener(AAEClient::initScreens);
        eventBus.addListener(AAEClient::initItemBlockRenderTypes);
        eventBus.addListener(AAEClient::initItemColours);
        eventBus.addListener(AAEClient::initRenderers);
        eventBus.addListener(AAEClient::initClientExtensions);
        eventBus.addListener(this::registerHotkeys);
        INSTANCE = this;
        NeoForge.EVENT_BUS.addListener(e -> AAEHotkeys.INSTANCE.checkHotkeys());
    }

    private static void initBuiltInModels() {
        for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
            BuiltInModelHooks.addBuiltInModel((ResourceLocation)AdvancedAE.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new AAECraftingUnitModelProvider(type)));
        }
    }

    private static void initScreens(RegisterMenuScreensEvent event) {
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_COMPUTER.get(), QuantumComputerScreen::new, (String)"/screens/quantum_computer.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.ADV_PATTERN_PROVIDER.get(), AdvPatternProviderScreen::new, (String)"/screens/adv_pattern_provider.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.SMALL_ADV_PATTERN_PROVIDER.get(), SmallAdvPatternProviderScreen::new, (String)"/screens/small_adv_pattern_provider.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.ADV_PATTERN_ENCODER.get(), AdvPatternEncoderScreen::new, (String)"/screens/adv_pattern_encoder.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.REACTION_CHAMBER.get(), ReactionChamberScreen::new, (String)"/screens/reaction_chamber.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_CRAFTER.get(), QuantumCrafterScreen::new, (String)"/screens/quantum_crafter.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_CRAFTER_TERMINAL.get(), QuantumCrafterTermScreen::new, (String)"/screens/quantum_crafter_terminal.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_CRAFTER_WIRELESS_TERMINAL.get(), QuantumCrafterWirelessTermScreen::new, (String)"/screens/wireless_quantum_crafter_terminal.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.STOCK_EXPORT_BUS.get(), StockExportBusScreen::new, (String)"/screens/stock_export_bus.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.IMPORT_EXPORT_BUS.get(), ImportExportBusScreen::new, (String)"/screens/import_export_bus.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.ADVANCED_IO_BUS.get(), AdvancedIOBusScreen::new, (String)"/screens/advanced_io_bus.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.CRAFTER_PATTERN_CONFIG.get(), QuantumCrafterConfigPatternScreen::new, (String)"/screens/quantum_crafter_pattern_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_CONFIG.get(), QuantumArmorConfigScreen::new, (String)"/screens/quantum_armor_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_NUM_INPUT.get(), QuantumArmorNumInputConfigScreen::new, (String)"/screens/quantum_armor_num_input_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG.get(), QuantumArmorFilterConfigScreen::new, (String)"/screens/quantum_armor_filter_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_MAGNET.get(), QuantumArmorMagnetScreen::new, (String)"/screens/quantum_armor_magnet.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), QuantumArmorStyleConfigScreen::new, (String)"/screens/quantum_armor_style.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.PORTABLE_WORKBENCH.get(), PortableWorkbenchScreen::new, (String)"/screens/portable_workbench.json");
    }

    private static void initItemBlockRenderTypes(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)AAEFluids.QUANTUM_INFUSION.source(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)AAEFluids.QUANTUM_INFUSION.flowing(), (RenderType)RenderType.translucent());
        });
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        AAEHotkeys.INSTANCE.finalizeRegistration(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.THROUGHPUT_MONITOR.asItem()});
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.QUANTUM_CRAFTER_TERMINAL.asItem()});
        for (ItemDefinition<?> item : AAEItems.getQuantumArmor()) {
            event.register((stack, index) -> index == 1 ? ((Integer)stack.getOrDefault(LibComponents.TINT_COLOR_TAG, (Object)Colors.PURPLE.argb())).intValue() : Colors.WHITE.argb(), new ItemLike[]{item});
        }
        for (FluidDefinition bucket : AAEFluids.INSTANCE.getFluids()) {
            event.getItemColors().register(FluidRegistry::getFluidColor, new ItemLike[]{bucket.bucketItem()});
        }
    }

    private static void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(AAEBlockEntities.REACTION_CHAMBER.get(), ReactionChamberTESR::new);
    }

    private static void initClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)AAEFluids.QUANTUM_INFUSION.fluidType(), new FluidType[]{AAEFluids.QUANTUM_INFUSION.fluidType()});
    }

    private static ItemColor makeOpaque(ItemColor itemColor) {
        return (stack, tintIndex) -> FastColor.ARGB32.opaque((int)itemColor.getColor(stack, tintIndex));
    }

    public static AAEClient instance() {
        return INSTANCE;
    }
}

