/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.cluster;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.GridCraftingCpuChange;
import appeng.api.networking.events.GridEvent;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;

public class AdvCraftingCPUCalculator
extends MBCalculator<AdvCraftingBlockEntity, AdvCraftingCPUCluster> {
    public AdvCraftingCPUCalculator(AdvCraftingBlockEntity t) {
        super((IAEMultiBlock)t);
    }

    public boolean checkMultiblockScale(BlockPos min, BlockPos max) {
        int maxSize = AAEConfig.instance().getQuantumComputerMaxSize() - 1;
        if (max.getX() - min.getX() > maxSize) {
            return false;
        }
        if (max.getY() - min.getY() > maxSize) {
            return false;
        }
        return max.getZ() - min.getZ() <= maxSize;
    }

    public AdvCraftingCPUCluster createCluster(ServerLevel level, BlockPos min, BlockPos max) {
        return new AdvCraftingCPUCluster(min, max);
    }

    public boolean verifyInternalStructure(ServerLevel level, BlockPos min, BlockPos max) {
        boolean core = false;
        boolean storage = false;
        int entangler = 0;
        int entanglerLimit = AAEConfig.instance().getQuantumComputermaxDataEntanglers();
        int multi = 0;
        int multiLimit = AAEConfig.instance().getQuantumComputerMaxMultiThreaders();
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            IAEMultiBlock te = (IAEMultiBlock)level.getBlockEntity(blockPos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (te instanceof AdvCraftingBlockEntity) {
                AdvCraftingBlockEntity advEntity = (AdvCraftingBlockEntity)te;
                boolean isBoundary = blockPos.getX() == min.getX() || blockPos.getY() == min.getY() || blockPos.getZ() == min.getZ() || blockPos.getX() == max.getX() || blockPos.getY() == max.getY() || blockPos.getZ() == max.getZ();
                switch ((AAECraftingUnitType)advEntity.getUnitBlock().type) {
                    case QUANTUM_CORE: {
                        if (min.equals((Object)max)) {
                            return true;
                        }
                        if (!isBoundary && !core) {
                            core = true;
                            break;
                        }
                        return false;
                    }
                    case STRUCTURE: {
                        if (isBoundary) break;
                        return false;
                    }
                    case STORAGE_MULTIPLIER: {
                        if (!isBoundary && entangler < entanglerLimit) {
                            ++entangler;
                            break;
                        }
                        return false;
                    }
                    case MULTI_THREADER: {
                        if (!isBoundary && multi < multiLimit) {
                            ++multi;
                            break;
                        }
                        return false;
                    }
                    default: {
                        if (!isBoundary) break;
                        return false;
                    }
                }
                if (storage) continue;
                storage = advEntity.getStorageBytes() > 0L;
                continue;
            }
            return false;
        }
        return storage && core;
    }

    public void updateBlockEntities(AdvCraftingCPUCluster c, ServerLevel level, BlockPos min, BlockPos max) {
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            AdvCraftingBlockEntity te = (AdvCraftingBlockEntity)level.getBlockEntity(blockPos);
            te.updateStatus(c);
            c.addBlockEntity(te);
        }
        c.done();
        Iterator<AdvCraftingBlockEntity> i = c.getBlockEntities();
        while (i.hasNext()) {
            AdvCraftingBlockEntity gh = i.next();
            IGridNode n = gh.getGridNode();
            if (n == null) continue;
            IGrid g = n.getGrid();
            g.postEvent((GridEvent)new GridCraftingCpuChange(n));
            return;
        }
    }

    public boolean isValidBlockEntity(BlockEntity te) {
        return te instanceof AdvCraftingBlockEntity;
    }
}

