/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.inventory;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.gui.AdvPatternEncoderMenu;
import net.pedroksl.ae2addonlib.registry.helpers.LibComponents;

public class AdvPatternEncoderHost
extends ItemMenuHost<AdvPatternEncoderItem>
implements InternalInventoryHost {
    private final AppEngInternalInventory inOutInventory = new AppEngInternalInventory((InternalInventoryHost)this, 2);
    private AdvPatternEncoderMenu.InventoryChangedHandler invChangeHandler;

    public AdvPatternEncoderHost(AdvPatternEncoderItem item, Player player, ItemMenuHostLocator locator) {
        super((Item)item, player, locator);
        CompoundTag itemTag = (CompoundTag)this.getItemStack().get(LibComponents.NBT_TAG);
        RegistryAccess registry = player.registryAccess();
        if (itemTag != null) {
            this.inOutInventory.readFromNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        }
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        CompoundTag itemTag = new CompoundTag();
        RegistryAccess registry = this.getPlayer().registryAccess();
        this.inOutInventory.writeToNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(LibComponents.NBT_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(LibComponents.NBT_TAG);
        }
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        CompoundTag itemTag = (CompoundTag)this.getItemStack().getOrDefault(LibComponents.NBT_TAG, (Object)new CompoundTag());
        RegistryAccess registry = this.getPlayer().registryAccess();
        if (this.inOutInventory == inv) {
            this.inOutInventory.writeToNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        }
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(LibComponents.NBT_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(LibComponents.NBT_TAG);
        }
        if (this.invChangeHandler != null) {
            this.invChangeHandler.handleChange((InternalInventory)inv, slot);
        }
    }

    public String getCloseHotkey() {
        return AAEHotkeysRegistry.Keys.PATTERN_ENCODER_HOTKEY.getId();
    }

    public AppEngInternalInventory getInventory() {
        return this.inOutInventory;
    }

    public void setInventoryChangedHandler(AdvPatternEncoderMenu.InventoryChangedHandler handler) {
        this.invChangeHandler = handler;
    }
}

