/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.recipes.InitRecipeTypes;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberRecipe
implements Recipe<RecipeInput> {
    public static final ResourceLocation TYPE_ID = AdvancedAE.makeId("reaction");
    public static final RecipeType<ReactionChamberRecipe> TYPE = InitRecipeTypes.register(TYPE_ID.toString());
    protected final List<IngredientStack.Item> inputs;
    protected final IngredientStack.Fluid fluid;
    public final GenericStack output;
    protected final int energy;

    public ReactionChamberRecipe(GenericStack output, List<IngredientStack.Item> inputs, IngredientStack.Fluid fluid, int energy) {
        this.inputs = inputs;
        this.output = output;
        this.fluid = fluid;
        this.energy = energy;
    }

    public boolean matches(@NotNull RecipeInput recipeInput, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem();
    }

    public boolean isItemOutput() {
        return this.output.what() instanceof AEItemKey;
    }

    public ItemStack getResultItem() {
        AEKey aEKey = this.output.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey key = (AEItemKey)aEKey;
            return key.toStack((int)this.output.amount());
        }
        return ItemStack.EMPTY;
    }

    public FluidStack getResultFluid() {
        AEKey aEKey = this.output.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey key = (AEFluidKey)aEKey;
            return key.toStack((int)this.output.amount());
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ReactionChamberRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public List<IngredientStack.Item> getInputs() {
        return this.inputs;
    }

    public List<IngredientStack<?, ?>> getValidInputs() {
        ArrayList validInputs = new ArrayList();
        for (IngredientStack.Item input : this.inputs) {
            if (input.isEmpty()) continue;
            validInputs.add((IngredientStack<?, ?>)input.sample());
        }
        validInputs.add((IngredientStack<?, ?>)this.fluid.sample());
        return validInputs;
    }

    @Nullable
    public IngredientStack.Fluid getFluid() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean containsIngredient(ItemStack stack) {
        for (IngredientStack.Item input : this.inputs) {
            if (input.isEmpty() || !((Ingredient)input.getIngredient()).test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIngredient(FluidStack stack) {
        return ((FluidIngredient)this.fluid.getIngredient()).test(stack);
    }
}

