/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.fluids;

import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class QuantumInfusionFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties((Supplier)AAEFluids.QUANTUM_INFUSION.fluidTypeId(), (Supplier)AAEFluids.QUANTUM_INFUSION.flowingId(), (Supplier)AAEFluids.QUANTUM_INFUSION.sourceId()).bucket((Supplier)AAEFluids.QUANTUM_INFUSION.bucketItemId()).block((Supplier)AAEFluids.QUANTUM_INFUSION.blockId());

    protected QuantumInfusionFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid getFlowing() {
        return AAEFluids.QUANTUM_INFUSION.flowing();
    }

    public Fluid getSource() {
        return AAEFluids.QUANTUM_INFUSION.source();
    }

    public Item getBucket() {
        return AAEFluids.QUANTUM_INFUSION.bucketItem();
    }

    protected boolean canConvertToSource(Level pLevel) {
        return false;
    }

    public static class Source
    extends QuantumInfusionFluid {
        public Source() {
            super(PROPERTIES);
        }

        public int getAmount(FluidState pState) {
            return 8;
        }

        public boolean isSource(FluidState pState) {
            return true;
        }
    }

    public static class Flowing
    extends QuantumInfusionFluid {
        public Flowing() {
            super(PROPERTIES);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.createFluidStateDefinition(pBuilder);
            pBuilder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState pState) {
            return false;
        }
    }
}

