/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.parts.SelectedPart;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ISubMenuHost;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.core.localization.Tooltips;
import appeng.menu.ISubMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.me.crafting.CraftAmountMenu;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.PickCraftMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.packet.MenuSelectionPacket;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;

public class QuantumChestplate
extends QuantumArmorBase
implements GeoItem,
ISubMenuHost {
    private static final double MAX_POWER_STORAGE = 3.0E8;

    public QuantumChestplate(Item.Properties properties) {
        super((Holder<ArmorMaterial>)AAEMaterials.QUANTUM_ALLOY.holder(), ArmorItem.Type.CHESTPLATE, properties, () -> 3.0E8);
        this.registerUpgrades(UpgradeType.FLIGHT, UpgradeType.HP_BUFFER, UpgradeType.LAVA_IMMUNITY, UpgradeType.REGENERATION, UpgradeType.STRENGTH, UpgradeType.ATTACK_SPEED, UpgradeType.CHARGING, UpgradeType.PICK_CRAFT);
    }

    @Override
    protected void appendExtraHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        lines.add((Component)AAEText.QuantumArmorStableFootingTooltip.text().withStyle(Tooltips.NUMBER_TEXT));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId == 36 + EquipmentSlot.CHEST.getIndex() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getPassiveUpgrades(stack).isEmpty()) {
                this.tickUpgrades(level, player, stack);
            }
            this.toggleBoneVisibilities(stack, player);
        }
    }

    private void toggleBoneVisibilities(ItemStack stack, Player player) {
        GeoRenderProvider provider;
        HumanoidModel renderer;
        QuantumArmorBase item = (QuantumArmorBase)stack.getItem();
        Object renderProvider = item.getRenderProvider();
        if (renderProvider instanceof GeoRenderProvider && (renderer = (provider = (GeoRenderProvider)renderProvider).getGeoArmorRenderer((LivingEntity)player, stack, EquipmentSlot.CHEST, null)) instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            boolean visible = stack.has(AAEComponents.UPGRADE_TOGGLE.get((Object)UpgradeType.STRENGTH));
            quantumRenderer.setBoneVisible("blade_left", visible);
            quantumRenderer.setBoneVisible("blade_right", visible);
        }
    }

    @Override
    public boolean openFromEquipmentSlot(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        ItemStack is = locator.locateItem(player);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            player.getPersistentData().putInt("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.openFromEquipmentSlot(player, locator, returningFromSubmenu);
    }

    public boolean attemptCraftingTarget(Player player, ItemMenuHostLocator locator) {
        ItemStack is = locator.locateItem(player);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            UpgradeType upgrade;
            QuantumChestplate chestStack = (QuantumChestplate)is.getItem();
            if (chestStack.hasUpgrade(is, upgrade = UpgradeType.PICK_CRAFT)) {
                if (chestStack.isUpgradeEnabled(is, upgrade)) {
                    AEKey key = this.targetKey(player);
                    if (key != null) {
                        if (this.keyIsCraftable(player, is, key)) {
                            player.getPersistentData().putInt("aae$menutype", QuantumArmorBase.MenuId.CRAFTING.id);
                            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.CRAFTING.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            CraftAmountMenu.open((ServerPlayer)((ServerPlayer)player), (MenuHostLocator)locator, (AEKey)key, (int)1);
                        } else {
                            player.displayClientMessage((Component)AAEText.ItemNotCraftable.text(), true);
                        }
                    } else {
                        player.displayClientMessage((Component)AAEText.NoAvailableTarget.text(), true);
                    }
                } else {
                    MutableComponent id = Component.translatable((String)((QuantumUpgradeBaseItem)upgrade.item().asItem()).getDescriptionId());
                    player.displayClientMessage((Component)AAEText.UpgradeNotEnabledMessage.text(new Object[]{id}), true);
                }
            } else {
                MutableComponent id = Component.translatable((String)((QuantumUpgradeBaseItem)upgrade.item().asItem()).getDescriptionId());
                player.displayClientMessage((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
            }
        }
        return false;
    }

    @Override
    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        if (player.getPersistentData().contains("aae$menutype") && player.getPersistentData().getInt("aae$menutype") == QuantumArmorBase.MenuId.STANDARD.id) {
            player.getPersistentData().remove("aae$menutype");
            return super.getMenuHost(player, locator, hitResult);
        }
        player.getPersistentData().remove("aae$menutype");
        return new PickCraftMenuHost<QuantumChestplate>(this, player, locator);
    }

    private AEKey targetKey(Player player) {
        BlockHitResult blockHitResult;
        HitResult hitResult = player.pick(player.blockInteractionRange(), 0.0f, false);
        if (hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
            BlockEntity blockEntity;
            BlockPos blockPos = blockHitResult.getBlockPos();
            BlockState blockState = player.level().getBlockState(blockPos);
            ItemStack itemStack = blockState.getBlock().asItem().getDefaultInstance();
            if (blockState.hasBlockEntity() && (blockEntity = player.level().getBlockEntity(blockPos)) != null) {
                if (blockEntity instanceof CableBusBlockEntity) {
                    CableBusBlockEntity cable = (CableBusBlockEntity)blockEntity;
                    SelectedPart part = QuantumChestplate.getSelectedPart(cable, hitResult);
                    if (part != null && part.part != null) {
                        itemStack = new ItemStack((ItemLike)part.part.getPartItem().asItem(), 1);
                    }
                } else {
                    blockEntity.saveToItem(itemStack, (HolderLookup.Provider)player.registryAccess());
                }
            }
            return AEItemKey.of((ItemStack)itemStack.getItem().getDefaultInstance());
        }
        return null;
    }

    private static SelectedPart getSelectedPart(CableBusBlockEntity cable, HitResult hitResult) {
        double z;
        double y;
        Vec3 loc = hitResult.getLocation();
        double x = loc.x - (double)((int)loc.x);
        if (x < 0.0) {
            x += 1.0;
        }
        if ((y = loc.y - (double)((int)loc.y)) < 0.0) {
            y += 1.0;
        }
        if ((z = loc.z - (double)((int)loc.z)) < 0.0) {
            z += 1.0;
        }
        Vec3 vec = new Vec3(x, y, z);
        return cable.selectPartLocal(vec);
    }

    public boolean keyIsCraftable(Player player, ItemStack stack, AEKey whatToCraft) {
        MutableObject errorHolder = new MutableObject();
        IGrid grid = this.getLinkedGrid(stack, player.level(), arg_0 -> ((MutableObject)errorHolder).setValue(arg_0));
        if (grid != null) {
            return grid.getCraftingService().isCraftable(whatToCraft);
        }
        player.displayClientMessage((Component)errorHolder.getValue(), true);
        return false;
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
    }

    public ItemStack getMainMenuIcon() {
        return AAEItems.QUANTUM_CHESTPLATE.stack();
    }
}

