/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.MaterialDefinition;
import org.jetbrains.annotations.NotNull;

public class AAELanguageProvider
extends LanguageProvider {
    public AAELanguageProvider(PackOutput output) {
        super(output, "advanced_ae", "en_us");
    }

    protected void addTranslations() {
        for (ItemDefinition item : AAEItems.INSTANCE.getItems()) {
            this.add(item.asItem(), item.getEnglishName());
        }
        for (BlockDefinition block : AAEBlocks.INSTANCE.getBlocks()) {
            this.add(block.block(), block.getEnglishName());
        }
        for (FluidDefinition fluid : AAEFluids.INSTANCE.getFluids()) {
            this.add(fluid.fluidType(), fluid.getEnglishName());
            this.add(fluid.flowing(), fluid.getEnglishName());
            this.add(fluid.source(), fluid.getEnglishName());
            this.add((Block)fluid.block(), fluid.getEnglishName());
            this.add((Item)fluid.bucketItem(), fluid.bucketItemId().getEnglishName());
        }
        for (AAEText translation : AAEText.values()) {
            this.add(translation.getTranslationKey(), translation.getEnglishText());
        }
        for (MaterialDefinition material : AAEMaterials.INSTANCE.getMaterials()) {
            this.add(material.get(), material.getEnglishName());
        }
        for (AAEHotkeysRegistry.Keys key : AAEHotkeysRegistry.Keys.values()) {
            this.add("key.advanced_ae." + key.getId(), key.getEnglishTranslation());
        }
        for (UpgradeType upgrade : UpgradeType.values()) {
            this.add(upgrade.getTranslationKey(), upgrade.name);
        }
        this.generateLocalizations();
    }

    private void generateLocalizations() {
        this.add("key.advanced_ae.category", "Advanced AE");
        this.add("key.ae2.wireless_quantum_crafter_terminal", "Open Wireless Quantum Crafter Terminal");
        this.add("curios.identifier.adv_pattern_encoder", "Pattern Encoder");
    }

    public void add(FluidType key, String englishName) {
        this.add(Util.makeDescriptionId((String)"fluid_type", (ResourceLocation)NeoForgeRegistries.FLUID_TYPES.getKey((Object)key)), englishName);
    }

    public void add(Fluid key, String englishName) {
        this.add(Util.makeDescriptionId((String)"fluid", (ResourceLocation)BuiltInRegistries.FLUID.getKey((Object)key)), englishName);
    }

    public void add(ArmorMaterial key, String englishName) {
        this.add(Util.makeDescriptionId((String)"material", (ResourceLocation)BuiltInRegistries.ARMOR_MATERIAL.getKey((Object)key)), englishName);
    }

    @NotNull
    public String getName() {
        return "Language";
    }
}

