/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import appeng.api.stacks.GenericStack;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;

public class QuantumArmorUpgradeFilterPacket
implements IMessage<QuantumArmorUpgradeFilterPacket> {
    private UpgradeType upgradeType;
    private List<GenericStack> filter;

    public QuantumArmorUpgradeFilterPacket() {
    }

    public QuantumArmorUpgradeFilterPacket(UpgradeType upgradeType, List<GenericStack> filter) {
        this.upgradeType = upgradeType;
        this.filter = filter;
    }

    public void fromBytes(FriendlyByteBuf stream) {
        this.upgradeType = (UpgradeType)stream.m_130066_(UpgradeType.class);
        int size = stream.readInt();
        ArrayList<GenericStack> list = new ArrayList<GenericStack>();
        for (int i = 0; i < size; ++i) {
            list.add(GenericStack.readBuffer((FriendlyByteBuf)stream));
        }
        this.filter = list;
    }

    public void toBytes(FriendlyByteBuf data) {
        data.m_130068_((Enum)this.upgradeType);
        data.writeInt(this.filter.size());
        for (GenericStack genericStack : this.filter) {
            GenericStack.writeBuffer((GenericStack)genericStack, (FriendlyByteBuf)data);
        }
    }

    public void onMessage(Player serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorConfigMenu) {
            QuantumArmorConfigMenu menu = (QuantumArmorConfigMenu)abstractContainerMenu;
            menu.openFilterConfigScreen(this.upgradeType, this.filter);
        }
    }

    public Class<QuantumArmorUpgradeFilterPacket> getPacketClass() {
        return QuantumArmorUpgradeFilterPacket.class;
    }

    public boolean isClient() {
        return false;
    }
}

