/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ILinkStatus;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.util.inv.AppEngInternalInventory;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.document.LytRect;
import guideme.render.SimpleRenderContext;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.ShowQuantumCrafters;
import net.pedroksl.advanced_ae.client.gui.AutoCrafterContainerRecord;
import net.pedroksl.advanced_ae.client.gui.PatternSlot;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEServerSettingToggleButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.QuantumCrafterTermMenu;

public class QuantumCrafterTermScreen<C extends QuantumCrafterTermMenu>
extends AEBaseScreen<C> {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 99;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 17);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 17, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 53, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 89, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 35, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 71, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 107, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 125, 195, 99);
    private final HashMap<Long, AutoCrafterContainerRecord> byId = new HashMap();
    private final HashMap<Long, Int2ObjectMap<Button>> configButtons = new HashMap();
    private final HashMap<Long, Int2ObjectMap<AECheckbox>> enableButtons = new HashMap();
    private final ArrayList<AutoCrafterContainerRecord> records = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar;
    private final AETextField searchField;
    private final Map<ItemStack, String> patternSearchText = new WeakHashMap<ItemStack, String>();
    private int visibleRows = 0;
    private final AAEServerSettingToggleButton<ShowQuantumCrafters> showQuantumCrafters;

    public QuantumCrafterTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.BIG);
        this.imageWidth = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showQuantumCrafters = new AAEServerSettingToggleButton<ShowQuantumCrafters>(AAESettings.TERMINAL_SHOW_QUANTUM_CRAFTERS, ShowQuantumCrafters.VISIBLE);
        this.addToLeftToolbar(this.showQuantumCrafters);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
    }

    public void init() {
        this.visibleRows = Math.max(2, this.config.getTerminalStyle().getRows((this.height - 17 - 99 - 54) / 18));
        this.imageHeight = 116 + this.visibleRows * 18;
        super.init();
        this.setInitialFocus((GuiEventListener)this.searchField);
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> {
            this.setVisibility((AbstractButton)value, false);
            this.addRenderableWidget((GuiEventListener)value);
        }));
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> {
            this.setVisibility((AbstractButton)value, false);
            this.addRenderableWidget((GuiEventListener)value);
        }));
        this.resetScrollbar();
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((QuantumCrafterTermMenu)this.menu).slots.removeIf(slot -> slot instanceof PatternSlot);
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> this.setVisibility((AbstractButton)value, false)));
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> this.setVisibility((AbstractButton)value, false)));
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        ClientLevel level = Minecraft.getInstance().level;
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            Button button;
            int col;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (row instanceof ConfigRow) {
                ConfigRow configRow = (ConfigRow)row;
                Int2ObjectMap<Button> configMap = this.configButtons.get(configRow.serverId);
                for (col = 0; col < configRow.slots; ++col) {
                    button = (Button)configMap.get(col);
                    button.setPosition(offsetX + col * 18 + 8, offsetY + (i + 1) * 18);
                }
                configMap.forEach((key, value) -> this.setVisibility((AbstractButton)value, true));
                continue;
            }
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                for (int col2 = 0; col2 < slotsRow.slots; ++col2) {
                    PatternSlot slot2 = new PatternSlot(slotsRow.container, slotsRow.offset + col2, col2 * 18 + 8, (i + 1) * 18);
                    ((QuantumCrafterTermMenu)this.menu).slots.add((Object)slot2);
                    ItemStack pattern = slotsRow.container.getInventory().getStackInSlot(slotsRow.offset + col2);
                    if ((pattern.isEmpty() || PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)level) != null) && !slotsRow.container.getInvalidArray().get(slotsRow.offset + col2)) continue;
                    guiGraphics.fill(slot2.x, slot2.y, slot2.x + 16, slot2.y + 16, 0x7FFF0000);
                }
                continue;
            }
            if (!(row instanceof EnabledRow)) continue;
            EnabledRow enabledRow = (EnabledRow)row;
            if (!this.enableButtons.containsKey(enabledRow.container.getServerId())) continue;
            Int2ObjectMap<AECheckbox> buttonMap = this.enableButtons.get(enabledRow.container.getServerId());
            for (col = 0; col < enabledRow.slots; ++col) {
                button = (AECheckbox)buttonMap.get(col);
                button.setPosition(offsetX + col * 18 + 8 + 1, offsetY + (i + 1) * 18);
                button.setSelected(enabledRow.container.getEnabledArray().get(enabledRow.offset + col));
            }
            buttonMap.forEach((key, value) -> this.setVisibility((AbstractButton)value, true));
        }
        this.renderLinkStatus(guiGraphics, ((QuantumCrafterTermMenu)this.getMenu()).getLinkStatus());
    }

    private void renderLinkStatus(GuiGraphics guiGraphics, ILinkStatus linkStatus) {
        if (!linkStatus.connected()) {
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            LytRect rect = new LytRect(7, 17, 162, this.visibleRows * 18);
            renderContext.fillRect(rect, (ColorValue)new ConstantColor(0x3F000000));
            Component statusDescription = linkStatus.statusDescription();
            if (statusDescription != null) {
                renderContext.renderTextCenteredIn(statusDescription.getString(), ERROR_TEXT_STYLE, rect);
            }
        }
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.isMouseOver(xCoord, yCoord)) {
            this.searchField.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void slotClicked(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            PatternSlot machineSlot = (PatternSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().getAbilities().instabuild) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.slot, machineSlot.getMachineInv().getServerId());
                PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        super.slotClicked(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.setWidth(8 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean charTyped(char character, int key) {
        if (character == ' ' && this.searchField.getValue().isEmpty()) {
            return true;
        }
        return super.charTyped(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, int inventorySize, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) {
        AutoCrafterContainerRecord record = new AutoCrafterContainerRecord(inventoryId, inventorySize, sortBy);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        Int2BooleanArrayMap enabled = record.getEnabledArray();
        for (Int2BooleanMap.Entry entry : enabledArray.int2BooleanEntrySet()) {
            enabled.put(entry.getIntKey(), entry.getBooleanValue());
        }
        Int2BooleanArrayMap invalid = record.getInvalidArray();
        for (Int2BooleanMap.Entry entry : invalidArray.int2BooleanEntrySet()) {
            invalid.put(entry.getIntKey(), entry.getBooleanValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) {
        AutoCrafterContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        Int2BooleanArrayMap enabled = record.getEnabledArray();
        for (Int2BooleanMap.Entry entry : enabledArray.int2BooleanEntrySet()) {
            enabled.put(entry.getIntKey(), entry.getBooleanValue());
        }
        Int2BooleanArrayMap invalid = record.getInvalidArray();
        for (Int2BooleanMap.Entry entry : invalidArray.int2BooleanEntrySet()) {
            invalid.put(entry.getIntKey(), entry.getBooleanValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showQuantumCrafters.set(((QuantumCrafterTermMenu)this.menu).getShownQuantumCrafters());
    }

    private void refreshList() {
        this.records.clear();
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> this.removeWidget((GuiEventListener)value)));
        this.configButtons.clear();
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> this.removeWidget((GuiEventListener)value)));
        this.enableButtons.clear();
        String searchFilterLowerCase = this.searchField.getValue().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (AutoCrafterContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                ItemStack itemStack;
                Iterator iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = (ItemStack)iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found) {
                this.records.add(entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        ArrayList<AutoCrafterContainerRecord> containers = new ArrayList<AutoCrafterContainerRecord>(this.records);
        Collections.sort(containers);
        for (AutoCrafterContainerRecord container : containers) {
            AppEngInternalInventory inventory = container.getInventory();
            for (int offset = 0; offset < inventory.size(); offset += 9) {
                int slots = Math.min(inventory.size() - offset, 9);
                Int2ObjectArrayMap configButtons = new Int2ObjectArrayMap();
                Int2ObjectArrayMap enabledButtons = new Int2ObjectArrayMap();
                for (int col = 0; col < 9; ++col) {
                    int index = offset + col;
                    QuantumCrafterScreen.ConfigButton cfgButton = new QuantumCrafterScreen.ConfigButton(b -> ((QuantumCrafterTermMenu)this.menu).configPattern(container.getServerId(), index));
                    configButtons.put(index, (Object)((Button)this.addRenderableWidget((GuiEventListener)cfgButton)));
                    AECheckbox enabledButton = new AECheckbox(0, 0, 12, 12, this.style, (Component)Component.empty());
                    enabledButton.setChangeListener(() -> ((QuantumCrafterTermMenu)this.menu).toggleEnabledPattern(container.getServerId(), index));
                    enabledButton.setRadio(true);
                    enabledButton.setTooltip(Tooltip.create((Component)AAEText.EnablePatternButton.text()));
                    enabledButtons.put(index, (Object)((AECheckbox)this.addRenderableWidget((GuiEventListener)enabledButton)));
                }
                this.configButtons.put(container.getServerId(), (Int2ObjectMap<Button>)configButtons);
                this.enableButtons.put(container.getServerId(), (Int2ObjectMap<AECheckbox>)enabledButtons);
                this.rows.add(new ConfigRow(container.getServerId(), slots));
                this.rows.add(new SlotsRow(container, offset, slots));
                this.rows.add(new EnabledRow(container, offset, slots));
            }
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.isEmpty()) {
            return false;
        }
        return this.patternSearchText.computeIfAbsent(itemStack, this::getPatternSearchText).contains(searchTerm);
    }

    private String getPatternSearchText(ItemStack stack) {
        Level level = ((QuantumCrafterTermMenu)this.menu).getPlayer().level();
        StringBuilder text = new StringBuilder();
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (pattern != null) {
            for (GenericStack output : pattern.getOutputs()) {
                output.what().getDisplayName().visit(content -> {
                    text.append(content.toLowerCase());
                    return Optional.empty();
                });
                text.append('\n');
            }
        }
        return text.toString();
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.children().removeAll(this.renderables);
        this.renderables.clear();
        this.init();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private void setVisibility(AbstractButton b, boolean visibility) {
        b.visible = visibility;
        b.active = visibility;
    }

    private int getMaxRows() {
        return this.byId.size() * 3;
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/quantum_crafter_terminal.png");
        guiGraphics.blit(texture, offsetX, offsetY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    protected int getVisibleRows() {
        return this.visibleRows;
    }

    static sealed interface Row
    permits ConfigRow, SlotsRow, EnabledRow {
    }

    record ConfigRow(long serverId, int slots) implements Row
    {
    }

    record SlotsRow(AutoCrafterContainerRecord container, int offset, int slots) implements Row
    {
    }

    record EnabledRow(AutoCrafterContainerRecord container, int offset, int slots) implements Row
    {
    }
}

