/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import org.jetbrains.annotations.NotNull;

public class AAESlider
implements ICompositeWidget {
    protected static final WidgetSprites SPRITES = new WidgetSprites(AppEng.makeId((String)"button"), AppEng.makeId((String)"button_disabled"), AppEng.makeId((String)"button_highlighted"));
    private static final int HANDLE_WIDTH = 8;
    private static final int HANDLE_HALF_WIDTH = 4;
    protected boolean isHovered;
    protected Point position = new Point(0, 0);
    protected int width = 100;
    protected int height = 20;
    protected float alpha = 1.0f;
    protected double value = 0.0;
    protected double minValue = 0.0;
    protected double maxValue = 1.0;
    protected double stepSize = 1.0;
    private final DecimalFormat format;
    private boolean isDragging = false;
    private boolean canChangeValue;
    private Consumer<Double> setter;

    public AAESlider() {
        this(value -> {});
    }

    public AAESlider(Consumer<Double> setter) {
        this.setter = setter;
        this.format = new DecimalFormat("0");
    }

    public AAESlider(double minValue, double maxValue, double currentValue, double stepSize, Consumer<Double> setter) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.setter = setter;
        this.format = new DecimalFormat("0");
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.setFractionalValue((value - this.minValue) / (this.maxValue - this.minValue));
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setValues(double minValue, double maxValue, double currentValue, float stepSize) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.setValue(currentValue);
    }

    public void setCallback(Consumer<Double> setter) {
        this.setter = setter;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int mouseX = bounds.getX() + mouse.getX();
        int mouseY = bounds.getY() + mouse.getY();
        int minX = bounds.getX() + this.position.getX();
        int minY = bounds.getY() + this.position.getY();
        this.isHovered = guiGraphics.containsPointInScissor(mouseX, mouseY) && mouseX >= minX && mouseY >= minY && mouseX < minX + this.width && mouseY < minY + this.height;
        this.renderWidget(guiGraphics, new Point(minX, minY), mouse);
    }

    protected void renderWidget(GuiGraphics guiGraphics, Point topLeft, Point mouse) {
        int minX = topLeft.getX();
        int minY = topLeft.getY();
        int heightUsedForText = 10;
        int minSliderY = minY + heightUsedForText;
        int sliderHeight = this.height - heightUsedForText;
        int maxX = minX + this.width;
        int maxY = minY + this.height;
        int middleX = minX + this.width / 2;
        int middleY = minSliderY + sliderHeight / 2;
        int backColor = AAEColor.LIGHT_GRAY.argb((int)(this.alpha * 255.0f));
        int lineColor = AAEColor.DARK_GRAY_BLUE.argb((int)(this.alpha * 255.0f));
        guiGraphics.fill(minX - 2, minSliderY - 2, maxX + 2, maxY + 2, Color.WHITE.getRGB());
        guiGraphics.fill(minX - 1, minSliderY - 1, maxX + 1, maxY + 1, backColor);
        guiGraphics.hLine(minX, maxX - 1, middleY, lineColor);
        guiGraphics.vLine(minX, minSliderY, maxY, lineColor);
        guiGraphics.vLine(maxX - 1, minSliderY, maxY, lineColor);
        Font font = Minecraft.getInstance().font;
        String minText = this.getValueText(this.minValue);
        guiGraphics.drawString(font, minText, minX, minY, lineColor, false);
        String maxText = this.getValueText(this.maxValue);
        guiGraphics.drawString(font, maxText, maxX - font.width(maxText), minY, lineColor, false);
        String currentText = this.getValueText(this.getValue());
        guiGraphics.drawString(font, currentText, middleX - font.width(currentText) / 2, minY, lineColor, false);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(this.getHandleSprite(), minX + (int)(this.value * (double)(this.width - 8)), minSliderY - 1, 8, this.height - 8);
    }

    private String getValueText(double value) {
        if (this.stepSize < 1.0) {
            return String.format("%.1f", value);
        }
        return String.format("%.0f", value);
    }

    public boolean onMouseDown(Point mousePos, int button) {
        if (button != 0) {
            return false;
        }
        this.isDragging = true;
        this.playDownSound();
        this.setValueFromMouse(mousePos.getX());
        return true;
    }

    private void playDownSound() {
        SoundManager handler = Minecraft.getInstance().getSoundManager();
        handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean onMouseUp(Point mousePos, int button) {
        this.isDragging = false;
        return false;
    }

    public boolean onMouseWheel(Point mousePos, double delta) {
        if (delta > 0.0) {
            this.setValue(Math.min(this.maxValue, this.getValue() + this.stepSize));
        } else {
            this.setValue(Math.max(this.minValue, this.getValue() - this.stepSize));
        }
        return true;
    }

    public boolean wantsAllMouseUpEvents() {
        return true;
    }

    public boolean onMouseDrag(Point mousePos, int button) {
        if (this.isDragging) {
            this.setValueFromMouse(mousePos.getX());
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setFractionalValue((mouseX - (double)this.position.getX()) / (double)this.width);
    }

    private void setFractionalValue(double fractionalValue) {
        double oldValue = this.value;
        this.value = this.snapToNearest(Math.clamp(fractionalValue, 0.0, 1.0));
        if (!Mth.equal((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.clamp((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.clamp((double)value, (double)this.maxValue, (double)this.minValue) : Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.map((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void applyValue() {
        this.setter.accept(this.getValue());
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.position.getX(), this.position.getY(), this.width, this.height);
    }

    @NotNull
    protected ResourceLocation getHandleSprite() {
        return SPRITES.get(this.isVisible(), this.isHovered);
    }
}

