/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.inventory;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.gui.AdvPatternEncoderMenu;

public class AdvPatternEncoderHost
extends ItemMenuHost<AdvPatternEncoderItem>
implements InternalInventoryHost {
    private final AppEngInternalInventory inOutInventory = new AppEngInternalInventory((InternalInventoryHost)this, 2);
    private AdvPatternEncoderMenu.InventoryChangedHandler invChangeHandler;

    public AdvPatternEncoderHost(AdvPatternEncoderItem item, Player player, ItemMenuHostLocator locator) {
        super((Item)item, player, locator);
        CompoundTag itemTag = (CompoundTag)this.getItemStack().get(AAEComponents.STACK_TAG);
        RegistryAccess registry = player.registryAccess();
        if (itemTag != null) {
            this.inOutInventory.readFromNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        }
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        CompoundTag itemTag = new CompoundTag();
        RegistryAccess registry = this.getPlayer().registryAccess();
        this.inOutInventory.writeToNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(AAEComponents.STACK_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(AAEComponents.STACK_TAG);
        }
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        CompoundTag itemTag = (CompoundTag)this.getItemStack().getOrDefault(AAEComponents.STACK_TAG, (Object)new CompoundTag());
        RegistryAccess registry = this.getPlayer().registryAccess();
        if (this.inOutInventory == inv) {
            this.inOutInventory.writeToNBT(itemTag, "inOutInventory", (HolderLookup.Provider)registry);
        }
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(AAEComponents.STACK_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(AAEComponents.STACK_TAG);
        }
        if (this.invChangeHandler != null) {
            this.invChangeHandler.handleChange((InternalInventory)inv, slot);
        }
    }

    public String getCloseHotkey() {
        return AAEHotkeys.Keys.PATTERN_ENCODER_HOTKEY.getId();
    }

    public AppEngInternalInventory getInventory() {
        return this.inOutInventory;
    }

    public void setInventoryChangedHandler(AdvPatternEncoderMenu.InventoryChangedHandler handler) {
        this.invChangeHandler = handler;
    }
}

