/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import net.pedroksl.advanced_ae.common.helpers.RadiationShieldingProvider;
import net.pedroksl.advanced_ae.common.inventory.QuantumArmorMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.IUpgradeableItem;
import net.pedroksl.advanced_ae.common.items.armors.PoweredItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.apoth.ApoEnchPlugin;
import net.pedroksl.advanced_ae.xmod.mekansim.MekanismPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class QuantumArmorBase
extends PoweredItem
implements GeoItem,
IMenuItem,
IUpgradeableItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final int DEFAULT_TINT_COLOR = AAEColor.PURPLE.argb();
    protected final List<UpgradeType> possibleUpgrades = new ArrayList<UpgradeType>();
    protected static final UUID ATTACK_DAMAGE_MOD = UUID.fromString("7c305230-fd62-4f14-8364-934bfc86ce74");
    protected static final UUID ATTACK_SPEED_MOD = UUID.fromString("47e9e666-e9a4-4bd7-8cce-ea2774b3fbc5");
    protected static final UUID LUCK_MOD = UUID.fromString("64e83581-dcdb-4045-a749-ce2f45d47e48");
    protected static final UUID REACH_MOD = UUID.fromString("2083e57d-4744-4d2b-bad5-5517c13a1734");
    protected static final UUID HP_BUFFER_MOD = UUID.fromString("d610c37e-3223-4e85-80dc-cb6fd58bfc81");
    protected static final UUID STEP_ASSIST_MOD = UUID.fromString("c1a4d757-50dc-49e9-a8a3-8e1b3fc91686");
    protected static final String MENU_TYPE = "aae$menutype";

    public QuantumArmorBase(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, DoubleSupplier powerCapacity) {
        super(material, type, properties.m_41486_().m_41497_(Rarity.EPIC).m_41487_(1), powerCapacity);
    }

    protected void registerUpgrades(UpgradeType ... upgrades) {
        this.possibleUpgrades.addAll(Arrays.asList(upgrades));
    }

    public int getTintColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("tint_color")) {
            return tag.m_128451_("tint_color");
        }
        return DEFAULT_TINT_COLOR;
    }

    public void setTintColor(Player player, ItemStack stack, int color) {
        stack.m_41784_().m_128405_("tint_color", color);
        HumanoidModel renderer = IClientItemExtensions.of((ItemStack)stack).getHumanoidArmorModel((LivingEntity)player, stack, stack.getEquipmentSlot(), null);
        if (renderer instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            quantumRenderer.setTintColor(color);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @NotNull Level context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, context, lines, advancedTooltips);
        Hotkeys.AAEHotkey hotkey = Hotkeys.getHotkeyMapping(AAEHotkeys.Keys.ARMOR_CONFIG.getId());
        if (hotkey != null) {
            lines.add((Component)AAEText.QuantumArmorHotkeyTooltip.text(new Object[]{hotkey.mapping().m_90863_().m_6881_().m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.appendExtraHoverText(stack, context, lines, advancedTooltips);
        if (this.getLinkedPosition(stack) == null) {
            lines.add((Component)Tooltips.of((GuiText)GuiText.Unlinked, (Style)Tooltips.RED, (Object[])new Object[0]));
        } else {
            lines.add((Component)Tooltips.of((GuiText)GuiText.Linked, (Style)Tooltips.GREEN, (Object[])new Object[0]));
        }
        lines.add((Component)Component.m_237119_());
        lines.add((Component)AAEText.QuantumArmorTooltip.text().m_130948_(Tooltips.NORMAL_TOOLTIP_TEXT));
        for (UpgradeType upgrade : this.possibleUpgrades) {
            MutableComponent upgradeComponent = Component.m_237115_((String)upgrade.item().m_5456_().m_5524_());
            if (!this.hasUpgrade(stack, upgrade)) {
                upgradeComponent.m_7220_((Component)AAEText.UpgradeNotInstalled.text());
                upgradeComponent.m_130940_(Tooltips.MUTED_COLOR);
            } else {
                upgradeComponent.m_130948_(Tooltips.GREEN);
            }
            lines.add((Component)upgradeComponent);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        Item item = stack.m_41720_();
        if (!(item instanceof QuantumArmorBase)) {
            return modifiers;
        }
        QuantumArmorBase armor = (QuantumArmorBase)item;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(modifiers);
        switch (slot) {
            case HEAD: {
                if (!armor.isUpgradeEnabledAndPowered(stack, UpgradeType.LUCK)) break;
                int value = armor.getUpgradeValue(stack, UpgradeType.LUCK, 0);
                AttributeModifier att = new AttributeModifier(LUCK_MOD, "aae_luck", (double)value, AttributeModifier.Operation.ADDITION);
                builder.put((Object)Attributes.f_22286_, (Object)att);
                break;
            }
            case CHEST: {
                AttributeModifier att;
                int value;
                if (armor.isUpgradeEnabledAndPowered(stack, UpgradeType.HP_BUFFER)) {
                    value = armor.getUpgradeValue(stack, UpgradeType.HP_BUFFER, 0);
                    att = new AttributeModifier(HP_BUFFER_MOD, "aae_hp_buffer", (double)value, AttributeModifier.Operation.ADDITION);
                    builder.put((Object)Attributes.f_22276_, (Object)att);
                }
                if (armor.isUpgradeEnabledAndPowered(stack, UpgradeType.STRENGTH)) {
                    value = armor.getUpgradeValue(stack, UpgradeType.STRENGTH, 0);
                    att = new AttributeModifier(ATTACK_DAMAGE_MOD, "aae_strength_boost", (double)value, AttributeModifier.Operation.ADDITION);
                    builder.put((Object)Attributes.f_22281_, (Object)att);
                }
                if (!armor.isUpgradeEnabledAndPowered(stack, UpgradeType.ATTACK_SPEED)) break;
                value = armor.getUpgradeValue(stack, UpgradeType.ATTACK_SPEED, 0);
                att = new AttributeModifier(ATTACK_SPEED_MOD, "aae_attack_speed", (double)value, AttributeModifier.Operation.ADDITION);
                builder.put((Object)Attributes.f_22283_, (Object)att);
                break;
            }
            case LEGS: {
                if (!armor.isUpgradeEnabledAndPowered(stack, UpgradeType.REACH)) break;
                int value = armor.getUpgradeValue(stack, UpgradeType.REACH, 0);
                AttributeModifier att = new AttributeModifier(REACH_MOD, "aae_reach_boost", (double)value, AttributeModifier.Operation.ADDITION);
                builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)att);
                builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)att);
                break;
            }
            case FEET: {
                if (!armor.isUpgradeEnabledAndPowered(stack, UpgradeType.STEP_ASSIST)) break;
                int value = armor.getUpgradeValue(stack, UpgradeType.STEP_ASSIST, 0);
                AttributeModifier att = new AttributeModifier(STEP_ASSIST_MOD, "aae_step_assist", (double)value, AttributeModifier.Operation.ADDITION);
                builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)att);
            }
        }
        return builder.build();
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    protected void appendExtraHoverText(ItemStack stack, @NotNull Level context, List<Component> lines, TooltipFlag advancedTooltips) {
    }

    @Override
    public List<UpgradeType> getPossibleUpgrades() {
        return this.possibleUpgrades;
    }

    protected boolean checkPreconditions(ItemStack item) {
        return !item.m_41619_() && item.m_41720_() == this;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (Addons.APOTHIC_ENCHANTING.isLoaded() && ApoEnchPlugin.isSameAs(enchantment, ApoEnchPlugin.Enchantment.STABLE_FOOTING)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean openFromEquipmentSlot(Player player, int inventorySlot, ItemStack stack) {
        return this.openFromEquipmentSlot(player, inventorySlot, stack, false);
    }

    public boolean openFromEquipmentSlot(Player player, int inventorySlot, ItemStack stack, boolean returningFromSubmenu) {
        if (!player.m_9236_().m_5776_() && this.checkPreconditions(stack)) {
            return MenuOpener.open(AAEMenus.QUANTUM_ARMOR_CONFIG.get(), (Player)player, (MenuLocator)MenuLocators.forInventorySlot((int)inventorySlot), (boolean)returningFromSubmenu);
        }
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.consumeEnergy(player, stack, amount);
        }
        return 0;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private QuantumArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new QuantumArmorRenderer();
                }
                this.renderer.setTintColor(QuantumArmorBase.this.getTintColor(itemStack));
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.quantum_armor.idle"));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (!(entity instanceof Player)) {
                return PlayState.CONTINUE;
            }
            Player player = (Player)entity;
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : player.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new QuantumArmorBase[]{AAEItems.QUANTUM_BOOTS.get(), AAEItems.QUANTUM_LEGGINGS.get(), AAEItems.QUANTUM_CHESTPLATE.get(), AAEItems.QUANTUM_HELMET.get()}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        return new QuantumArmorMenuHost(player, inventorySlot, stack, (p, subMenu) -> this.openFromEquipmentSlot((Player)p, inventorySlot, stack, true));
    }

    public static List<QuantumArmorBase> upgradeAvailableFor(UpgradeType type) {
        ArrayList<QuantumArmorBase> list = new ArrayList<QuantumArmorBase>();
        for (AAEItemDefinition<?> equip : AAEItems.getQuantumArmor()) {
            QuantumArmorBase armor = (QuantumArmorBase)equip.stack().m_41720_();
            if (!armor.possibleUpgrades.contains((Object)type)) continue;
            list.add(armor);
        }
        return list;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        RadiationShieldingProvider cap;
        if (Addons.MEKANISM.isLoaded() && (cap = MekanismPlugin.attachCapability(stack)) != null) {
            return cap;
        }
        return super.initCapabilities(stack, nbt);
    }

    protected static enum MenuId {
        STANDARD(0),
        WORKBENCH(1),
        CRAFTING(2);

        public final int id;

        private MenuId(int id) {
            this.id = id;
        }
    }
}

