/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.DisabledSlot;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAESlotSemantics;
import net.pedroksl.advanced_ae.common.inventory.QuantumArmorMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;

public class QuantumArmorStyleConfigMenu
extends AEBaseMenu
implements ISubMenu {
    private final QuantumArmorMenuHost host;
    @GuiSync(value=13)
    public int slotIndex;
    private static final String SELECT_SLOT = "select_slot";
    public static final String LAST_SLOT_INDEX = "aae$lastSlotIndex";

    public QuantumArmorStyleConfigMenu(int id, Inventory playerInventory, QuantumArmorMenuHost host) {
        super(AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), id, playerInventory, (Object)host);
        this.host = host;
        int indexOfFirstQuantum = -1;
        for (int i = 3; i >= 0; --i) {
            int index = 36 + i;
            DisabledSlot slot = new DisabledSlot((Container)playerInventory, index);
            if (slot.m_7993_().m_41720_() instanceof QuantumArmorBase && indexOfFirstQuantum == -1) {
                indexOfFirstQuantum = index;
            }
            this.addSlot((Slot)slot, AAESlotSemantics.ARMOR);
        }
        this.registerClientAction(SELECT_SLOT, Integer.class, this::setSelectedItemSlot);
        if (this.getPlayer().getPersistentData().m_128441_(LAST_SLOT_INDEX)) {
            this.setSelectedItemSlot(this.getPlayer().getPersistentData().m_128451_(LAST_SLOT_INDEX));
        } else {
            this.setSelectedItemSlot(indexOfFirstQuantum);
        }
    }

    public QuantumArmorMenuHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, int slotIndex) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), (Player)player, (MenuLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorStyleConfigMenu) {
            QuantumArmorStyleConfigMenu cca = (QuantumArmorStyleConfigMenu)abstractContainerMenu;
            cca.setSlotIndex(Math.abs(slotIndex - player.m_150109_().m_6643_() - 3));
            cca.m_38946_();
        }
    }

    public void setSlotIndex(int index) {
        this.slotIndex = index;
    }

    public void setSelectedItemSlot(int index) {
        if (this.isClientSide()) {
            this.sendClientAction(SELECT_SLOT, index);
            this.getPlayer().getPersistentData().m_128405_(LAST_SLOT_INDEX, index);
            return;
        }
        this.host.setSelectedItemSlot(index);
    }

    public void updateItemColors(List<Integer> slots, int color) {
        for (Integer slotIndex : slots) {
            Item item;
            Slot slot = this.m_38853_(slotIndex);
            if (slot == null || !slot.m_6657_() || !((item = slot.m_7993_().m_41720_()) instanceof QuantumArmorBase)) continue;
            QuantumArmorBase armor = (QuantumArmorBase)item;
            armor.setTintColor(this.getPlayerInventory().f_35978_, slot.m_7993_(), color);
        }
    }
}

