/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.core.localization.Tooltips;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class QuantumBoots
extends QuantumArmorBase {
    private static final double MAX_POWER_STORAGE = 2.0E8;

    public QuantumBoots(Item.Properties properties) {
        super((Holder<ArmorMaterial>)AAEMaterials.QUANTUM_ALLOY.material(), ArmorItem.Type.BOOTS, properties, () -> 2.0E8);
        this.registerUpgrades(UpgradeType.STEP_ASSIST, UpgradeType.JUMP_HEIGHT, UpgradeType.EVASION, UpgradeType.FLIGHT_DRIFT, UpgradeType.CHARGING);
    }

    @Override
    protected void appendExtraHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        lines.add((Component)AAEText.QuantumArmorFallDamageTooltip.text().withStyle(Tooltips.NUMBER_TEXT));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId == 36 + EquipmentSlot.FEET.getIndex() && !this.getPassiveUpgrades(stack).isEmpty() && entity instanceof Player) {
            Player player = (Player)entity;
            this.tickUpgrades(level, player, stack);
        }
    }
}

