/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.stacks.AEKey;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;
import net.pedroksl.ae2addonlib.network.AddonPacket;

public class AdvPatternEncoderPacket
extends AddonPacket {
    private final LinkedHashMap<AEKey, Direction> dirMap;

    public AdvPatternEncoderPacket(FriendlyByteBuf stream) {
        this.dirMap = new LinkedHashMap();
        int size = stream.readInt();
        for (int x = 0; x < size; ++x) {
            AEKey key = AEKey.readKey((FriendlyByteBuf)stream);
            Direction dir = stream.readBoolean() ? (Direction)stream.m_130066_(Direction.class) : null;
            this.dirMap.put(key, dir);
        }
    }

    public AdvPatternEncoderPacket(LinkedHashMap<AEKey, Direction> dirMap) {
        this.dirMap = dirMap;
    }

    public AdvPatternEncoderPacket() {
        this.dirMap = new LinkedHashMap();
    }

    protected void write(FriendlyByteBuf stream) {
        stream.writeInt(this.dirMap.size());
        for (Map.Entry<AEKey, Direction> entry : this.dirMap.entrySet()) {
            AEKey.writeKey((FriendlyByteBuf)stream, (AEKey)entry.getKey());
            Direction dir = entry.getValue();
            if (dir == null) {
                stream.writeBoolean(false);
                continue;
            }
            stream.writeBoolean(true);
            stream.m_130068_((Enum)entry.getValue());
        }
    }

    public void clientPacketData(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AdvPatternEncoderScreen) {
            AdvPatternEncoderScreen encoderGui = (AdvPatternEncoderScreen)screen;
            encoderGui.update(this.dirMap);
        }
    }
}

