/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeldingo<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modeldingo"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart leftleg;
    public final ModelPart rightleg;
    public final ModelPart leftarm;
    public final ModelPart rightarm;
    public final ModelPart tail;

    public Modeldingo(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftleg = root.getChild("leftleg");
        this.rightleg = root.getChild("rightleg");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(22, 13).addBox(-3.0f, -2.9157f, -4.0838f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 23).addBox(-1.5f, 0.0643f, -7.0838f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.4157f, (float)-6.9162f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(32, 34).addBox(-2.0f, -15.5f, -7.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 30).addBox(2.5f, -15.5f, -7.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)9.3343f, (float)7.9162f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)14.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -12.0f, -1.0f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-2.0f, (float)-4.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperbody_r1 = body.addOrReplaceChild("upperbody_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -13.0f, -1.0f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-3.0f, (float)-14.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.65f, (float)16.0f, (float)6.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(28, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.65f, (float)16.0f, (float)6.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(8, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)16.0f, (float)-5.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 30).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)16.0f, (float)-5.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)7.75f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(24, 30).addBox(0.0f, -12.0f, 7.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)13.85f, (float)-1.85f, (float)0.4974f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

