/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeldiprotodon<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modeldiprotodon"), "main");
    public final ModelPart rightleg;
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart head;
    public final ModelPart rightear;
    public final ModelPart leftear;
    public final ModelPart leftleg;
    public final ModelPart rightarm;
    public final ModelPart leftarm;

    public Modeldiprotodon(ModelPart root) {
        this.rightleg = root.getChild("rightleg");
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.head = root.getChild("head");
        this.rightear = this.head.getChild("rightear");
        this.leftear = this.head.getChild("leftear");
        this.leftleg = root.getChild("leftleg");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(86, 20).addBox(-3.5f, 6.8333f, -3.0f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(114, 91).addBox(-3.5f, 17.8333f, -5.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(74, 71).addBox(-4.0f, -5.1667f, -5.5f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)4.1667f, (float)13.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -9.0833f, -10.0f, 18.0f, 18.0f, 25.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-10.0f, -10.0833f, -27.0f, 20.0f, 20.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0833f, (float)6.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 104).addBox(-1.5f, -2.25f, 0.0f, 3.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5833f, (float)15.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(74, 43).addBox(-8.5f, -7.1063f, -10.8905f, 17.0f, 17.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(86, 0).addBox(-7.5f, -4.1063f, -17.8905f, 15.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(40, 80).addBox(-4.5f, -4.6063f, -18.8905f, 9.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.6063f, (float)-21.1095f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create(), PartPose.offset((float)-6.7781f, (float)-6.0906f, (float)-4.1643f));
        PartDefinition cube_r1 = rightear.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(82, 119).addBox(1.0f, -32.0f, -42.0f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.2781f, (float)22.9843f, (float)41.2738f, (float)0.0f, (float)0.2182f, (float)-0.3054f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create(), PartPose.offset((float)7.0281f, (float)-6.0906f, (float)-4.1643f));
        PartDefinition cube_r2 = leftear.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(94, 119).addBox(-6.0f, -32.0f, -42.0f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-13.5281f, (float)22.9843f, (float)41.2738f, (float)0.0f, (float)-0.2182f, (float)0.3054f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 80).addBox(-4.0f, -5.1667f, -5.5f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 104).addBox(-3.5f, 6.8333f, -3.0f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(28, 119).addBox(-3.5f, 17.8333f, -5.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)4.1667f, (float)13.5f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(80, 95).addBox(-4.0f, -5.1667f, -5.5f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(114, 71).addBox(-3.5f, 6.8333f, -3.0f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(64, 119).addBox(-3.5f, 17.8333f, -5.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)4.1667f, (float)-12.5f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(114, 20).addBox(-3.5f, 6.8333f, -3.0f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(40, 95).addBox(-4.0f, -5.1667f, -5.5f, 8.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(46, 119).addBox(-3.5f, 17.8333f, -5.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)4.1667f, (float)-12.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

