/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelferalcat<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelferalcat"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart backLegL;
    public final ModelPart backLegR;
    public final ModelPart frontLegL;
    public final ModelPart frontLegR;

    public Modelferalcat(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.backLegL = root.getChild("backLegL");
        this.backLegR = root.getChild("backLegR");
        this.frontLegL = root.getChild("frontLegL");
        this.frontLegR = root.getChild("frontLegR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 0).addBox(-2.5f, -2.0f, -5.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(28, 9).addBox(-1.5f, -0.02f, -6.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.25f, (float)-7.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(28, 16).addBox(-2.0f, -12.0f, -9.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, 13).addBox(1.0f, -12.0f, -9.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.1f, (float)5.7f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)1.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -9.0f, -18.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)-1.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 22).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)7.25f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition tail2_r1 = tail.addOrReplaceChild("tail2_r1", CubeListBuilder.create().texOffs(28, 19).addBox(-0.5f, -0.0992f, -0.6836f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9545f, (float)0.6782f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition backLegL = partdefinition.addOrReplaceChild("backLegL", CubeListBuilder.create().texOffs(0, 22).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.1f, (float)19.0f, (float)7.0f));
        PartDefinition backLegR = partdefinition.addOrReplaceChild("backLegR", CubeListBuilder.create().texOffs(8, 22).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.1f, (float)19.0f, (float)7.0f));
        PartDefinition frontLegL = partdefinition.addOrReplaceChild("frontLegL", CubeListBuilder.create().texOffs(20, 9).addBox(-1.0f, -1.25f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.2f, (float)15.05f, (float)-4.0f));
        PartDefinition frontLegR = partdefinition.addOrReplaceChild("frontLegR", CubeListBuilder.create().texOffs(20, 21).addBox(-1.0f, -1.25f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.2f, (float)15.05f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.backLegL.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.backLegR.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.frontLegL.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.frontLegR.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.backLegL.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.frontLegR.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.backLegR.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.frontLegL.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

