/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelgecko<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelgecko"), "main");
    public final ModelPart body;
    public final ModelPart rightlegs;
    public final ModelPart leftlegs;
    public final ModelPart tail;
    public final ModelPart head;

    public Modelgecko(ModelPart root) {
        this.body = root.getChild("body");
        this.rightlegs = root.getChild("rightlegs");
        this.leftlegs = root.getChild("leftlegs");
        this.tail = root.getChild("tail");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.0f, (float)0.5f));
        PartDefinition rightlegs = partdefinition.addOrReplaceChild("rightlegs", CubeListBuilder.create().texOffs(4, 7).addBox(-2.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)23.95f, (float)0.0f));
        PartDefinition leftlegs = partdefinition.addOrReplaceChild("leftlegs", CubeListBuilder.create().texOffs(6, 0).addBox(0.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)23.95f, (float)0.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.5f, (float)3.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(11, 10).addBox(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)22.6f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightlegs.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftlegs.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightlegs.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leftlegs.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

