/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelhyena<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelhyena"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart upperbody;
    public final ModelPart leftleg;
    public final ModelPart rightleg;
    public final ModelPart leftarm;
    public final ModelPart rightarm;
    public final ModelPart tail;

    public Modelhyena(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.upperbody = root.getChild("upperbody");
        this.leftleg = root.getChild("leftleg");
        this.rightleg = root.getChild("rightleg");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 10).addBox(-3.0f, -3.02f, -3.9649f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 31).addBox(-1.5f, -0.04f, -5.9649f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.02f, (float)-8.7851f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 42).addBox(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0532f, (float)-3.52f, (float)-1.3851f, (float)-0.0873f, (float)0.0873f, (float)0.0f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(16, 41).addBox(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0532f, (float)-3.52f, (float)-1.3851f, (float)-0.0873f, (float)-0.0873f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.75f, (float)3.25f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(29, 1).addBox(-2.0f, -5.0f, 1.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(1, 1).addBox(-2.0f, -14.0f, 0.0f, 6.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)3.25f, (float)6.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperbody = partdefinition.addOrReplaceChild("upperbody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.25f, (float)-5.25f));
        PartDefinition upperBody_r1 = upperbody.addOrReplaceChild("upperBody_r1", CubeListBuilder.create().texOffs(54, 26).addBox(-1.0f, -14.0f, 6.0f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.25f, (float)9.25f, (float)1.4399f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody_r2 = upperbody.addOrReplaceChild("upperBody_r2", CubeListBuilder.create().texOffs(4, 21).addBox(-1.0f, -15.0f, 2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)6.0f, (float)9.5f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody_r3 = upperbody.addOrReplaceChild("upperBody_r3", CubeListBuilder.create().texOffs(0, 17).addBox(-3.0f, -13.0f, -1.0f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.0f, (float)10.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(44, 20).addBox(-0.9167f, 8.0665f, -0.7224f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.1667f, (float)14.9835f, (float)5.7224f));
        PartDefinition leg1_r1 = leftleg.addOrReplaceChild("leg1_r1", CubeListBuilder.create().texOffs(30, 20).addBox(0.5f, -11.0f, 4.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1667f, (float)8.5165f, (float)-6.9724f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leg0_r1 = leftleg.addOrReplaceChild("leg0_r1", CubeListBuilder.create().texOffs(28, 38).addBox(1.5f, -7.0f, 6.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4167f, (float)10.2665f, (float)-6.2224f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(44, 23).addBox(-1.0833f, 8.0665f, -0.7224f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.1667f, (float)14.9835f, (float)5.7224f));
        PartDefinition leg1_r2 = rightleg.addOrReplaceChild("leg1_r2", CubeListBuilder.create().texOffs(36, 38).addBox(1.5f, -7.0f, 6.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5833f, (float)10.2665f, (float)-6.2224f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg2_r1 = rightleg.addOrReplaceChild("leg2_r1", CubeListBuilder.create().texOffs(30, 29).addBox(0.5f, -11.0f, 4.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.8333f, (float)8.5165f, (float)-6.9724f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(20, 31).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)16.0f, (float)-5.25f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)16.0f, (float)-5.25f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.2785f, (float)7.4221f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, -13.0f, 7.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)12.9715f, (float)-6.4221f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.upperbody.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

