/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelkoala<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelkoala"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightarm;
    public final ModelPart rightleg;
    public final ModelPart leftleg;
    public final ModelPart leftarm;

    public Modelkoala(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.rightarm = root.getChild("rightarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.leftarm = root.getChild("leftarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.25f, -8.125f, 6.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(24, 29).addBox(-1.0f, -1.25f, 2.125f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.75f, (float)3.125f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 17).addBox(-2.5f, -2.2602f, -2.75f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 29).addBox(-1.0f, -0.0102f, -3.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.7602f, (float)-4.5f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(26, 23).addBox(-6.0f, -10.0f, -4.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)5.9898f, (float)3.25f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(26, 17).addBox(3.0f, -10.0f, -4.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)5.9898f, (float)3.25f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(18, 17).addBox(-1.0f, -1.25f, -1.05f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 32).addBox(-1.0f, 5.75f, -2.05f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)18.25f, (float)-2.45f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(16, 26).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 0).addBox(-1.0f, 4.5f, -2.0f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)19.5f, (float)4.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(8, 26).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 33).addBox(-1.0f, 4.5f, -2.0f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)19.5f, (float)4.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(0, 26).addBox(-1.0f, -1.25f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 33).addBox(-1.0f, 5.75f, -2.0f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)18.25f, (float)-2.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

