/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelpossum<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelpossum"), "main");
    public final ModelPart rightleg;
    public final ModelPart rightarm;
    public final ModelPart leftarm;
    public final ModelPart leftleg;
    public final ModelPart tail;
    public final ModelPart body;
    public final ModelPart head;

    public Modelpossum(ModelPart root) {
        this.rightleg = root.getChild("rightleg");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
        this.leftleg = root.getChild("leftleg");
        this.tail = root.getChild("tail");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(30, 23).addBox(-1.0f, 3.8797f, -1.1649f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(-1.0f, -1.0703f, -0.8649f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0703f, (float)3.1149f));
        PartDefinition cube_r1 = rightleg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 29).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.6297f, (float)-0.6649f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(30, 26).addBox(-1.0f, 3.8797f, -1.1649f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 23).addBox(-1.0f, -1.0703f, -0.8649f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0703f, (float)-3.6351f));
        PartDefinition cube_r2 = rightarm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(24, 29).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.6297f, (float)-0.6649f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(8, 29).addBox(-1.0f, -1.0703f, -0.8649f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 3).addBox(-1.0f, 3.8797f, -1.1649f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)19.0703f, (float)-3.6351f));
        PartDefinition cube_r3 = leftarm.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(30, 19).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.6297f, (float)-0.6649f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 29).addBox(-1.0f, -1.0703f, -0.8649f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-1.0f, 3.8797f, -1.1649f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)19.0703f, (float)3.1149f));
        PartDefinition cube_r4 = leftleg.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(30, 15).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.6297f, (float)-0.6649f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 15).addBox(-1.5f, -1.5666f, 0.0539f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)20.0666f, (float)4.6961f));
        PartDefinition cube_r5 = tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(16, 22).addBox(-2.0f, -5.0f, 9.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)3.0834f, (float)-4.1961f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -7.0f, -1.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)24.0f, (float)-4.25f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 15).addBox(-2.0f, -2.0332f, -2.9977f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(32, 29).addBox(-1.0f, -0.0332f, -3.9977f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)17.7832f, (float)-5.2523f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(32, 10).addBox(0.0f, -10.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)5.7168f, (float)-0.7477f, (float)-0.6774f, (float)1.3242f, (float)-0.4797f));
        PartDefinition cube_r7 = head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(32, 6).addBox(-2.0f, -10.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)5.7168f, (float)-0.7477f, (float)-0.6774f, (float)-1.3242f, (float)0.4797f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

