/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelrat<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaturesdominion", (String)"modelrat"), "main");
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart uppertail;
    public final ModelPart leftarm;
    public final ModelPart rightarm;
    public final ModelPart rightleg;
    public final ModelPart leftleg;
    public final ModelPart head;

    public Modelrat(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.uppertail = this.tail.getChild("uppertail");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, -4.0f, 5.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.75f, (float)0.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)4.0f));
        PartDefinition uppertail = tail.addOrReplaceChild("uppertail", CubeListBuilder.create().texOffs(16, 19).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.25f, (float)6.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(0, 25).addBox(-0.5f, -0.75f, -0.875f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 25).addBox(-0.5f, 1.25f, -1.625f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.4f, (float)21.75f, (float)-2.625f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(18, 25).addBox(-0.5f, 1.25f, -1.625f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 25).addBox(-0.5f, -0.75f, -0.875f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.4f, (float)21.75f, (float)-2.625f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(6, 20).addBox(-0.5f, -1.0f, -0.875f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-0.5f, 2.0f, -1.625f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.4f, (float)21.0f, (float)2.375f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 20).addBox(-0.5f, -1.0f, -0.875f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 25).addBox(-0.5f, 2.0f, -1.625f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.4f, (float)21.0f, (float)2.375f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.5625f, -4.0625f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 3).addBox(-1.0f, -0.3125f, -4.3125f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.7125f, (float)-3.8875f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 20).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-2.0625f, (float)-0.5625f, (float)-0.1745f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(12, 22).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0625f, (float)-0.5625f, (float)-0.1745f, (float)0.0f, (float)-0.3054f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

