/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelbarramundi;
import net.mcreator.creaturesdominion.client.model.animations.barramundiAnimation;
import net.mcreator.creaturesdominion.entity.BarramundiEntity;
import net.mcreator.creaturesdominion.procedures.TrexvisualentityProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BarramundiRenderer
extends MobRenderer<BarramundiEntity, Modelbarramundi<BarramundiEntity>> {
    public BarramundiRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelbarramundi.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(BarramundiEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)TrexvisualentityProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BarramundiEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/barramundi.png");
    }

    private static final class AnimatedModel
    extends Modelbarramundi<BarramundiEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BarramundiEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BarramundiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(barramundiAnimation.swim, limbSwing, limbSwingAmount, 4.0f, 3.0f);
                this.animate(entity.animationState1, barramundiAnimation.flop, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BarramundiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

