/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelsnake;
import net.mcreator.creaturesdominion.client.model.animations.snakeAnimation;
import net.mcreator.creaturesdominion.entity.BrownSnakeEntity;
import net.mcreator.creaturesdominion.procedures.EntityEntityVisualScaleBabyProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BrownSnakeRenderer
extends MobRenderer<BrownSnakeEntity, Modelsnake<BrownSnakeEntity>> {
    public BrownSnakeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsnake.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(BrownSnakeEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)EntityEntityVisualScaleBabyProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BrownSnakeEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/snake.png");
    }

    private static final class AnimatedModel
    extends Modelsnake<BrownSnakeEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BrownSnakeEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BrownSnakeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(snakeAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                this.animate(entity.animationState1, snakeAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BrownSnakeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

