/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modeldodo;
import net.mcreator.creaturesdominion.client.model.animations.compyAnimation;
import net.mcreator.creaturesdominion.client.model.animations.dodoAnimation;
import net.mcreator.creaturesdominion.entity.DodoEntity;
import net.mcreator.creaturesdominion.procedures.KangarooEntityVisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class DodoRenderer
extends MobRenderer<DodoEntity, Modeldodo<DodoEntity>> {
    public DodoRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeldodo.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(DodoEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)KangarooEntityVisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(DodoEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/dodo.png");
    }

    private static final class AnimatedModel
    extends Modeldodo<DodoEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DodoEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DodoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, compyAnimation.baby, ageInTicks, 1.0f);
                this.animateWalk(dodoAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                this.animate(entity.animationState2, dodoAnimation.eat, ageInTicks, 1.0f);
                this.animate(entity.animationState3, dodoAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DodoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

