/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelenchodus;
import net.mcreator.creaturesdominion.client.model.animations.enchodusAnimation;
import net.mcreator.creaturesdominion.entity.EnchodusEntity;
import net.mcreator.creaturesdominion.procedures.EnchodusEntityVisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EnchodusRenderer
extends MobRenderer<EnchodusEntity, Modelenchodus<EnchodusEntity>> {
    public EnchodusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelenchodus.LAYER_LOCATION)), 0.4f);
    }

    protected void scale(EnchodusEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)EnchodusEntityVisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(EnchodusEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/enchodus.png");
    }

    private static final class AnimatedModel
    extends Modelenchodus<EnchodusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<EnchodusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(EnchodusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(enchodusAnimation.swim, limbSwing, limbSwingAmount, 4.0f, 3.0f);
                this.animate(entity.animationState1, enchodusAnimation.flop, ageInTicks, 1.0f);
                this.animate(entity.animationState2, enchodusAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(EnchodusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

