/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelfirefly;
import net.mcreator.creaturesdominion.client.model.animations.fireflyAnimation;
import net.mcreator.creaturesdominion.entity.FireflyEntity;
import net.mcreator.creaturesdominion.procedures.FireflyEntityVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class FireflyRenderer
extends MobRenderer<FireflyEntity, Modelfirefly<FireflyEntity>> {
    public FireflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelfirefly.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(FireflyEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)FireflyEntityVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(FireflyEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/firefly.png");
    }

    private static final class AnimatedModel
    extends Modelfirefly<FireflyEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<FireflyEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(FireflyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(fireflyAnimation.fly, limbSwing, limbSwingAmount, 2.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(FireflyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

