/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.creaturesdominion.client.model.Modelgallimimus;
import net.mcreator.creaturesdominion.client.model.animations.gallimimusAnimation;
import net.mcreator.creaturesdominion.entity.GallimimusEntity;
import net.mcreator.creaturesdominion.procedures.GallimimusDisplayConditionProcedure;
import net.mcreator.creaturesdominion.procedures.KangarooEntityVisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class GallimimusRenderer
extends MobRenderer<GallimimusEntity, Modelgallimimus<GallimimusEntity>> {
    public GallimimusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelgallimimus.LAYER_LOCATION)), 0.9f);
        this.addLayer((RenderLayer)new RenderLayer<GallimimusEntity, Modelgallimimus<GallimimusEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"creaturesdominion:textures/entities/gallimimussaddle.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GallimimusEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (GallimimusDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelgallimimus)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(GallimimusEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)KangarooEntityVisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GallimimusEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/gallimimus.png");
    }

    private static final class AnimatedModel
    extends Modelgallimimus<GallimimusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GallimimusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GallimimusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, gallimimusAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(gallimimusAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GallimimusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

