/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelgastornis;
import net.mcreator.creaturesdominion.client.model.animations.gastornisAnimation;
import net.mcreator.creaturesdominion.entity.GastornisEntity;
import net.mcreator.creaturesdominion.procedures.DingoentityvisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class GastornisRenderer
extends MobRenderer<GastornisEntity, Modelgastornis<GastornisEntity>> {
    public GastornisRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelgastornis.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(GastornisEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)DingoentityvisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GastornisEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/gastornis.png");
    }

    private static final class AnimatedModel
    extends Modelgastornis<GastornisEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GastornisEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GastornisEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(gastornisAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                this.animate(entity.animationState1, gastornisAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, gastornisAnimation.bite, ageInTicks, 1.0f);
                this.animate(entity.animationState3, gastornisAnimation.eat, ageInTicks, 1.0f);
                this.animate(entity.animationState4, gastornisAnimation.baby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GastornisEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

