/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.creaturesdominion.client.model.Modeliguanodone;
import net.mcreator.creaturesdominion.client.model.animations.iguanodoneAnimation;
import net.mcreator.creaturesdominion.entity.IgaunodonEntity;
import net.mcreator.creaturesdominion.procedures.EntityEntityVisualScaleBabyProcedure;
import net.mcreator.creaturesdominion.procedures.IguanodonDisplayConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class IgaunodonRenderer
extends MobRenderer<IgaunodonEntity, Modeliguanodone<IgaunodonEntity>> {
    public IgaunodonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeliguanodone.LAYER_LOCATION)), 1.5f);
        this.addLayer((RenderLayer)new RenderLayer<IgaunodonEntity, Modeliguanodone<IgaunodonEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"creaturesdominion:textures/entities/iguanodonsaddle.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, IgaunodonEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (IguanodonDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeliguanodone)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(IgaunodonEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)EntityEntityVisualScaleBabyProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(IgaunodonEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/iguanodon.png");
    }

    private static final class AnimatedModel
    extends Modeliguanodone<IgaunodonEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<IgaunodonEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(IgaunodonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(iguanodoneAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                this.animate(entity.animationState1, iguanodoneAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, iguanodoneAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(IgaunodonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

