/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelkangaroo;
import net.mcreator.creaturesdominion.client.model.animations.kangarooAnimation;
import net.mcreator.creaturesdominion.entity.KangarooEntity;
import net.mcreator.creaturesdominion.procedures.KangarooEntityVisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class KangarooRenderer
extends MobRenderer<KangarooEntity, Modelkangaroo<KangarooEntity>> {
    public KangarooRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelkangaroo.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(KangarooEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)KangarooEntityVisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(KangarooEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/kangaroo.png");
    }

    private static final class AnimatedModel
    extends Modelkangaroo<KangarooEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<KangarooEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(KangarooEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(kangarooAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.0f);
                this.animate(entity.animationState1, kangarooAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(KangarooEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

