/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelnarwhalee;
import net.mcreator.creaturesdominion.client.model.animations.narwhalAnimation;
import net.mcreator.creaturesdominion.entity.NarwhalEntity;
import net.mcreator.creaturesdominion.procedures.EntityEntityVisualScaleBabyProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class NarwhalRenderer
extends MobRenderer<NarwhalEntity, Modelnarwhalee<NarwhalEntity>> {
    public NarwhalRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelnarwhalee.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(NarwhalEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)EntityEntityVisualScaleBabyProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(NarwhalEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/narwhal.png");
    }

    private static final class AnimatedModel
    extends Modelnarwhalee<NarwhalEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<NarwhalEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(NarwhalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(narwhalAnimation.swim, limbSwing, limbSwingAmount, 4.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(NarwhalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

