/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modelstarfish;
import net.mcreator.creaturesdominion.client.model.animations.starfishAnimation;
import net.mcreator.creaturesdominion.entity.StarfishEntity;
import net.mcreator.creaturesdominion.procedures.CurrentlySwimmingProcedure;
import net.mcreator.creaturesdominion.procedures.EntityEntityVisualScaleBabyProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class StarfishRenderer
extends MobRenderer<StarfishEntity, Modelstarfish<StarfishEntity>> {
    public StarfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelstarfish.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(StarfishEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)EntityEntityVisualScaleBabyProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(StarfishEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/starfish.png");
    }

    private static final class AnimatedModel
    extends Modelstarfish<StarfishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<StarfishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(StarfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (CurrentlySwimmingProcedure.execute((Entity)entity)) {
                    this.animateWalk(starfishAnimation.swim, limbSwing, limbSwingAmount, 3.0f, 1.0f);
                }
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(StarfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

