/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.creaturesdominion.client.model.Modeltiger;
import net.mcreator.creaturesdominion.client.model.animations.lionAnimation;
import net.mcreator.creaturesdominion.entity.TigerEntity;
import net.mcreator.creaturesdominion.procedures.LionsneakProcedure;
import net.mcreator.creaturesdominion.procedures.TrexvisualentityProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TigerRenderer
extends MobRenderer<TigerEntity, Modeltiger<TigerEntity>> {
    public TigerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeltiger.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(TigerEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)TrexvisualentityProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(TigerEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/tiger.png");
    }

    private static final class AnimatedModel
    extends Modeltiger<TigerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<TigerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(TigerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (LionsneakProcedure.execute((Entity)entity)) {
                    this.animateWalk(lionAnimation.sneak, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                }
                this.animate(entity.animationState1, lionAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(TigerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

