/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.creaturesdominion.client.model.Modeltrex;
import net.mcreator.creaturesdominion.client.model.animations.trexAnimation;
import net.mcreator.creaturesdominion.entity.TyrannosawusEntity;
import net.mcreator.creaturesdominion.procedures.TrexvisualentityProcedure;
import net.mcreator.creaturesdominion.procedures.TyrannosawusDisplayConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TyrannosawusRenderer
extends MobRenderer<TyrannosawusEntity, Modeltrex<TyrannosawusEntity>> {
    public TyrannosawusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeltrex.LAYER_LOCATION)), 1.8f);
        this.addLayer((RenderLayer)new RenderLayer<TyrannosawusEntity, Modeltrex<TyrannosawusEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"creaturesdominion:textures/entities/trexsaddled.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, TyrannosawusEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (TyrannosawusDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeltrex)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(TyrannosawusEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)TrexvisualentityProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(TyrannosawusEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/tyrannosaurus.png");
    }

    private static final class AnimatedModel
    extends Modeltrex<TyrannosawusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<TyrannosawusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(TyrannosawusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(trexAnimation.walk, limbSwing, limbSwingAmount, 3.0f, 1.0f);
                this.animate(entity.animationState1, trexAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, trexAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(TyrannosawusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

