/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.creaturesdominion.client.model.Modelyutyrannus;
import net.mcreator.creaturesdominion.client.model.animations.yutyrannusAnimation;
import net.mcreator.creaturesdominion.entity.YutyrannusEntity;
import net.mcreator.creaturesdominion.procedures.YutyrannusDisplayConditionProcedure;
import net.mcreator.creaturesdominion.procedures.YutyrannusEntityVisualProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class YutyrannusRenderer
extends MobRenderer<YutyrannusEntity, Modelyutyrannus<YutyrannusEntity>> {
    public YutyrannusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelyutyrannus.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<YutyrannusEntity, Modelyutyrannus<YutyrannusEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"creaturesdominion:textures/entities/yutyrannussaddle.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, YutyrannusEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (YutyrannusDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelyutyrannus)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(YutyrannusEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)YutyrannusEntityVisualProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(YutyrannusEntity entity) {
        return ResourceLocation.parse((String)"creaturesdominion:textures/entities/yutyrannus.png");
    }

    private static final class AnimatedModel
    extends Modelyutyrannus<YutyrannusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<YutyrannusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(YutyrannusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(yutyrannusAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.0f);
                this.animate(entity.animationState1, yutyrannusAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, yutyrannusAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState3, yutyrannusAnimation.baby, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(YutyrannusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

