/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.entity;

import net.mcreator.creaturesdominion.init.CreaturesdominionModEntities;
import net.mcreator.creaturesdominion.init.CreaturesdominionModItems;
import net.mcreator.creaturesdominion.procedures.NarwhalOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class BlueSharkEntity
extends Animal {
    public BlueSharkEntity(EntityType<BlueSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (BlueSharkEntity.this.isInWater()) {
                    BlueSharkEntity.this.setDeltaMovement(BlueSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !BlueSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - BlueSharkEntity.this.getX();
                    double dy = this.wantedY - BlueSharkEntity.this.getY();
                    double dz = this.wantedZ - BlueSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * BlueSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    BlueSharkEntity.this.setYRot(this.rotlerp(BlueSharkEntity.this.getYRot(), f, 10.0f));
                    BlueSharkEntity.this.yBodyRot = BlueSharkEntity.this.getYRot();
                    BlueSharkEntity.this.yHeadRot = BlueSharkEntity.this.getYRot();
                    if (BlueSharkEntity.this.isInWater()) {
                        BlueSharkEntity.this.setSpeed((float)BlueSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        BlueSharkEntity.this.setXRot(this.rotlerp(BlueSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(BlueSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        BlueSharkEntity.this.setZza(f3 * f1);
                        BlueSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        BlueSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    BlueSharkEntity.this.setSpeed(0.0f);
                    BlueSharkEntity.this.setYya(0.0f);
                    BlueSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 2.0, 40));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = BlueSharkEntity.this.getRandom();
                double dir_x = BlueSharkEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = BlueSharkEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = BlueSharkEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 2.0));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 2.0));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)CreaturesdominionModItems.RAW_SHARK_MEAT.get()));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fish.swim")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void baseTick() {
        super.baseTick();
        NarwhalOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        BlueSharkEntity retval = (BlueSharkEntity)((EntityType)CreaturesdominionModEntities.BLUE_SHARK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:meat"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        BlueSharkEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CreaturesdominionModEntities.BLUE_SHARK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.9);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 5.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.9);
        return builder;
    }
}

