/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.entity;

import net.mcreator.creaturesdominion.entity.MoonJellyFishEntity;
import net.mcreator.creaturesdominion.init.CreaturesdominionModBlocks;
import net.mcreator.creaturesdominion.init.CreaturesdominionModEntities;
import net.mcreator.creaturesdominion.procedures.LeatherbackSeaTurtlePlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class LeatherBackTurtleEntity
extends Animal {
    public final AnimationState animationState0 = new AnimationState();

    public LeatherBackTurtleEntity(EntityType<LeatherBackTurtleEntity> type, Level world) {
        super(type, world);
        this.xpReward = 7;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (LeatherBackTurtleEntity.this.isInWater()) {
                    LeatherBackTurtleEntity.this.setDeltaMovement(LeatherBackTurtleEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !LeatherBackTurtleEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - LeatherBackTurtleEntity.this.getX();
                    double dy = this.wantedY - LeatherBackTurtleEntity.this.getY();
                    double dz = this.wantedZ - LeatherBackTurtleEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * LeatherBackTurtleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    LeatherBackTurtleEntity.this.setYRot(this.rotlerp(LeatherBackTurtleEntity.this.getYRot(), f, 10.0f));
                    LeatherBackTurtleEntity.this.yBodyRot = LeatherBackTurtleEntity.this.getYRot();
                    LeatherBackTurtleEntity.this.yHeadRot = LeatherBackTurtleEntity.this.getYRot();
                    if (LeatherBackTurtleEntity.this.isInWater()) {
                        LeatherBackTurtleEntity.this.setSpeed((float)LeatherBackTurtleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        LeatherBackTurtleEntity.this.setXRot(this.rotlerp(LeatherBackTurtleEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(LeatherBackTurtleEntity.this.getXRot() * ((float)Math.PI / 180)));
                        LeatherBackTurtleEntity.this.setZza(f3 * f1);
                        LeatherBackTurtleEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        LeatherBackTurtleEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    LeatherBackTurtleEntity.this.setSpeed(0.0f);
                    LeatherBackTurtleEntity.this.setYya(0.0f);
                    LeatherBackTurtleEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, MoonJellyFishEntity.class, true, false));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 4.0, 40));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.2));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = LeatherBackTurtleEntity.this.getRandom();
                double dir_x = LeatherBackTurtleEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = LeatherBackTurtleEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = LeatherBackTurtleEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 2.0));
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 2.0));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)CreaturesdominionModBlocks.SEA_LETTUCE.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.ambient_land"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(LeatherbackSeaTurtlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        LeatherBackTurtleEntity retval = (LeatherBackTurtleEntity)((EntityType)CreaturesdominionModEntities.LEATHER_BACK_TURTLE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SALMON)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TROPICAL_FISH)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModBlocks.SEA_LETTUCE.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.SEAGRASS)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:meat")))}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        LeatherBackTurtleEntity entity = this;
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CreaturesdominionModEntities.LEATHER_BACK_TURTLE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.8);
        builder = builder.add(Attributes.MAX_HEALTH, 29.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 53.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.8);
        return builder;
    }
}

