/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.entity;

import net.mcreator.creaturesdominion.init.CreaturesdominionModBlocks;
import net.mcreator.creaturesdominion.init.CreaturesdominionModEntities;
import net.mcreator.creaturesdominion.procedures.BabydisplayconditionmodelProcedure;
import net.mcreator.creaturesdominion.procedures.FishFloProcedure;
import net.mcreator.creaturesdominion.procedures.MOBIDLEwaterProcedure;
import net.mcreator.creaturesdominion.procedures.NarwhalOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class MoonJellyFishEntity
extends Animal {
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public MoonJellyFishEntity(EntityType<MoonJellyFishEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (MoonJellyFishEntity.this.isInWater()) {
                    MoonJellyFishEntity.this.setDeltaMovement(MoonJellyFishEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !MoonJellyFishEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - MoonJellyFishEntity.this.getX();
                    double dy = this.wantedY - MoonJellyFishEntity.this.getY();
                    double dz = this.wantedZ - MoonJellyFishEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * MoonJellyFishEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    MoonJellyFishEntity.this.setYRot(this.rotlerp(MoonJellyFishEntity.this.getYRot(), f, 10.0f));
                    MoonJellyFishEntity.this.yBodyRot = MoonJellyFishEntity.this.getYRot();
                    MoonJellyFishEntity.this.yHeadRot = MoonJellyFishEntity.this.getYRot();
                    if (MoonJellyFishEntity.this.isInWater()) {
                        MoonJellyFishEntity.this.setSpeed((float)MoonJellyFishEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        MoonJellyFishEntity.this.setXRot(this.rotlerp(MoonJellyFishEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(MoonJellyFishEntity.this.getXRot() * ((float)Math.PI / 180)));
                        MoonJellyFishEntity.this.setZza(f3 * f1);
                        MoonJellyFishEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        MoonJellyFishEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    MoonJellyFishEntity.this.setSpeed(0.0f);
                    MoonJellyFishEntity.this.setYya(0.0f);
                    MoonJellyFishEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, false, true){

            public boolean canUse() {
                double x = MoonJellyFishEntity.this.getX();
                double y = MoonJellyFishEntity.this.getY();
                double z = MoonJellyFishEntity.this.getZ();
                MoonJellyFishEntity entity = MoonJellyFishEntity.this;
                Level world = MoonJellyFishEntity.this.level();
                return super.canUse() && BabydisplayconditionmodelProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MoonJellyFishEntity.this.getX();
                double y = MoonJellyFishEntity.this.getY();
                double z = MoonJellyFishEntity.this.getZ();
                MoonJellyFishEntity entity = MoonJellyFishEntity.this;
                Level world = MoonJellyFishEntity.this.level();
                return super.canContinueToUse() && BabydisplayconditionmodelProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 2.0, 40));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = MoonJellyFishEntity.this.getRandom();
                double dir_x = MoonJellyFishEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = MoonJellyFishEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = MoonJellyFishEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 2.0));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 2.0));
        this.goalSelector.addGoal(9, (Goal)new RemoveBlockGoal(Blocks.FROGSPAWN, (PathfinderMob)this, 1.0, 12));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:smalljellyamb"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:smalljellyhurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:smalljellyhurt"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(FishFloProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ()), this.tickCount);
            this.animationState2.animateWhen(MOBIDLEwaterProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        NarwhalOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        MoonJellyFishEntity retval = (MoonJellyFishEntity)((EntityType)CreaturesdominionModEntities.MOON_JELLY_FISH.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModBlocks.GREEN_ALGAE.get()), new ItemStack((ItemLike)CreaturesdominionModBlocks.SEA_LETTUCE.get()), new ItemStack((ItemLike)Blocks.FROGSPAWN)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MoonJellyFishEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CreaturesdominionModEntities.MOON_JELLY_FISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.9);
        builder = builder.add(Attributes.MAX_HEALTH, 6.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 5.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.9);
        return builder;
    }
}

