/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.entity;

import net.mcreator.creaturesdominion.init.CreaturesdominionModEntities;
import net.mcreator.creaturesdominion.init.CreaturesdominionModItems;
import net.mcreator.creaturesdominion.procedures.WoolyCowPlaybackConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RatEntity
extends Animal {
    public final AnimationState animationState0 = new AnimationState();

    public RatEntity(EntityType<RatEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(9, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:ratambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:rathurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"creaturesdominion:ratdeath"));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(WoolyCowPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        RatEntity retval = (RatEntity)((EntityType)CreaturesdominionModEntities.RAT.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.APPLE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.CARROT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.POTATO)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUMPKIN_PIE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.MELON_SLICE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SWEET_BERRIES)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLOW_BERRIES)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.WHEAT_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUMPKIN_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TORCHFLOWER_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.MELON_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BEETROOT_SEEDS)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.BRAZILIAN_NUTS.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.FRESH_MACADAMIA_NUTS.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.RAW_REPTILE_MEAT.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.COOKED_REPTILE_MEAT.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.RAW_KANGAROO_MEAT.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.COOKED_KANGAROO_MEAT.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CreaturesdominionModItems.RAW_TUNA.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PORKCHOP)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BEEF)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.CHICKEN)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.RABBIT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.MUTTON)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BREAD)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:meat")))}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CreaturesdominionModEntities.RAT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.28);
        builder = builder.add(Attributes.MAX_HEALTH, 9.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

