/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public class ShrublandLeaveDecorator
extends LeaveVineDecorator {
    public static MapCodec<ShrublandLeaveDecorator> CODEC = MapCodec.unit(ShrublandLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"creaturesdominion:shrubland_tree_leave_decorator"), () -> DECORATOR_TYPE);
    }

    public ShrublandLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.west())) {
                ShrublandLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.east())) {
                ShrublandLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.north())) {
                ShrublandLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.south())) {
                ShrublandLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.setBlock(pos, Blocks.VINE.defaultBlockState());
        BlockPos blockpos = pos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            context.setBlock(blockpos, ShrublandLeaveDecorator.oriented(Blocks.VINE.defaultBlockState(), direction));
            blockpos = blockpos.below();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

