/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creaturesdominion.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public class ShrublandTrunkDecorator
extends TrunkVineDecorator {
    public static MapCodec<ShrublandTrunkDecorator> CODEC = MapCodec.unit(ShrublandTrunkDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"creaturesdominion:shrubland_tree_trunk_decorator"), () -> DECORATOR_TYPE);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.logs().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.west())) {
                context.setBlock(pos, ShrublandTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.EAST));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.east())) {
                context.setBlock(pos, ShrublandTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.WEST));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.north())) {
                context.setBlock(pos, ShrublandTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.SOUTH));
            }
            if (context.random().nextInt(3) > 0 && context.isAir(pos = blockpos.south())) {
                context.setBlock(pos, ShrublandTrunkDecorator.oriented(Blocks.VINE.defaultBlockState(), Direction.NORTH));
            }
        });
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

