/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.Metrics;
import me.athlaeos.valhallammo.UpdateChecker;
import me.athlaeos.valhallammo.block.BlockBreakNetworkHandlerImpl;
import me.athlaeos.valhallammo.block.BlockInteractConversions;
import me.athlaeos.valhallammo.commands.CommandManager;
import me.athlaeos.valhallammo.commands.LeaderboardCommand;
import me.athlaeos.valhallammo.commands.PartyChatCommand;
import me.athlaeos.valhallammo.commands.PartyCommand;
import me.athlaeos.valhallammo.commands.PartyManagementCommand;
import me.athlaeos.valhallammo.commands.PartySpyCommand;
import me.athlaeos.valhallammo.commands.ProfileCommand;
import me.athlaeos.valhallammo.commands.RedeemCommand;
import me.athlaeos.valhallammo.commands.SkillsCommand;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.configuration.ConfigUpdater;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierScalingPresets;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.entities.Dummy;
import me.athlaeos.valhallammo.entities.EntityAttributeStats;
import me.athlaeos.valhallammo.entities.MonsterScalingManager;
import me.athlaeos.valhallammo.event.PlayerJumpEvent;
import me.athlaeos.valhallammo.gui.MenuListener;
import me.athlaeos.valhallammo.hooks.CoreProtectHook;
import me.athlaeos.valhallammo.hooks.DecentHologramsHook;
import me.athlaeos.valhallammo.hooks.JustLootItHook;
import me.athlaeos.valhallammo.hooks.LootinHook;
import me.athlaeos.valhallammo.hooks.MythicMobsHook;
import me.athlaeos.valhallammo.hooks.NexoHook;
import me.athlaeos.valhallammo.hooks.PAPIHook;
import me.athlaeos.valhallammo.hooks.PluginHook;
import me.athlaeos.valhallammo.hooks.VaultHook;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.AlchemyItemPropertyManager;
import me.athlaeos.valhallammo.item.ArmorSetRegistry;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.PermanentPotionEffects;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.listeners.AnvilListener;
import me.athlaeos.valhallammo.listeners.ArmorSwitchListener;
import me.athlaeos.valhallammo.listeners.BlockDamageListener;
import me.athlaeos.valhallammo.listeners.BlockListener;
import me.athlaeos.valhallammo.listeners.BrewingStandListener;
import me.athlaeos.valhallammo.listeners.CauldronCraftingListener;
import me.athlaeos.valhallammo.listeners.ChatListener;
import me.athlaeos.valhallammo.listeners.CookingListener;
import me.athlaeos.valhallammo.listeners.CraftingTableListener;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.listeners.DeathListener;
import me.athlaeos.valhallammo.listeners.EnchantmentListener;
import me.athlaeos.valhallammo.listeners.EntityAttackListener;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.listeners.EntityResponsibilityListener;
import me.athlaeos.valhallammo.listeners.EntitySpawnListener;
import me.athlaeos.valhallammo.listeners.HandSwitchListener;
import me.athlaeos.valhallammo.listeners.HealthRegenerationListener;
import me.athlaeos.valhallammo.listeners.ImmersiveRecipeListener;
import me.athlaeos.valhallammo.listeners.InteractListener;
import me.athlaeos.valhallammo.listeners.ItemConsumptionListener;
import me.athlaeos.valhallammo.listeners.ItemDamageListener;
import me.athlaeos.valhallammo.listeners.JoinLeaveListener;
import me.athlaeos.valhallammo.listeners.JumpListener;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.listeners.MovementListener;
import me.athlaeos.valhallammo.listeners.PotionEffectListener;
import me.athlaeos.valhallammo.listeners.ProjectileListener;
import me.athlaeos.valhallammo.listeners.ReachAttackListener;
import me.athlaeos.valhallammo.listeners.RecipeDiscoveryListener;
import me.athlaeos.valhallammo.listeners.SmithingTableListener;
import me.athlaeos.valhallammo.listeners.WorldSaveListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.nms.NMS;
import me.athlaeos.valhallammo.nms.PacketListener;
import me.athlaeos.valhallammo.nms.Paper;
import me.athlaeos.valhallammo.parties.PartyManager;
import me.athlaeos.valhallammo.persistence.Database;
import me.athlaeos.valhallammo.persistence.ProfilePersistence;
import me.athlaeos.valhallammo.playerstats.LeaderboardManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.AlchemyProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.ArcheryProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.DiggingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.EnchantingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FarmingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FishingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.SmithingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.resourcepack.Host;
import me.athlaeos.valhallammo.resourcepack.ResourcePack;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpenseRegistry;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockConditionRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.tools.BlockHardnessStick;
import me.athlaeos.valhallammo.utility.GlobalEffect;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.AlphaToBetaConversionHandler;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ValhallaMMO
extends JavaPlugin {
    private static final boolean premium = false;
    private static boolean customMiningSystem = false;
    private static NMS nms = null;
    private static Paper paper = null;
    private static PacketListener packetListener = null;
    private static ValhallaMMO instance;
    private static boolean resourcePackConfigForced;
    private static final Map<Class<? extends PluginHook>, PluginHook> activeHooks;
    private static YamlConfiguration pluginConfig;
    private static final Collection<String> worldBlacklist;
    private static final boolean usingPaperMC;
    private static boolean enabled;
    private static boolean disabling;

    public ValhallaMMO() {
        instance = this;
    }

    public static ValhallaMMO getInstance() {
        return instance;
    }

    public void onLoad() {
        pluginConfig = this.saveAndUpdateConfig("config.yml");
        String lang = pluginConfig.getString("language", "en-us");
        this.save("languages/en-us.json");
        this.save("languages/materials/en-us.json");
        this.save("recipes/grid_recipes.json");
        this.save("recipes/brewing_recipes.json");
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_6)) {
            this.save("recipes/brewing_recipes_1_20_6+.json");
        }
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_9)) {
            this.save("recipes/grid_recipes_1_21_9+.json");
        }
        this.save("recipes/cooking_recipes.json");
        this.save("recipes/immersive_recipes.json");
        this.save("recipes/cauldron_recipes.json");
        this.save("recipes/smithing_recipes.json");
        this.save("items.json");
        this.save("loot_table_config.json");
        this.save("loot_tables/digging.json");
        this.save("loot_tables/fishing.json");
        this.save("loot_tables/woodcutting.json");
        this.save("replacement_table_config.json");
        this.save("replacement_tables/loot_valhallafication.json");
        this.saveConfig("recipes/disabled_recipes.yml");
        this.saveConfig("leaderboards.yml");
        this.saveConfig("mob_stats.yml");
        this.saveConfig("parties.yml");
        this.saveConfig("block_conversions.yml");
        this.saveConfig("scaling_presets.yml");
        this.saveConfig("alpha_conversion.yml");
        this.saveConfig("default_block_hardnesses.yml");
        this.saveConfig("skills/alchemy.yml");
        this.saveConfig("skills/alchemy_progression.yml");
        this.saveConfig("skills/alchemy_transmutations.yml");
        this.saveConfig("skills/archery.yml");
        this.saveConfig("skills/archery_progression.yml");
        this.saveConfig("skills/digging.yml");
        this.saveConfig("skills/digging_progression.yml");
        this.saveConfig("skills/enchanting.yml");
        this.saveConfig("skills/enchanting_progression.yml");
        this.saveConfig("skills/farming.yml");
        this.saveConfig("skills/farming_progression.yml");
        this.saveConfig("skills/fishing.yml");
        this.saveConfig("skills/fishing_progression.yml");
        this.saveConfig("skills/heavy_armor.yml");
        this.saveConfig("skills/heavy_armor_progression.yml");
        this.saveConfig("skills/heavy_weapons.yml");
        this.saveConfig("skills/heavy_weapons_progression.yml");
        this.saveConfig("skills/light_armor.yml");
        this.saveConfig("skills/light_armor_progression.yml");
        this.saveConfig("skills/light_weapons.yml");
        this.saveConfig("skills/light_weapons_progression.yml");
        this.saveConfig("skills/mining.yml");
        this.saveConfig("skills/mining_progression.yml");
        this.saveConfig("skills/power.yml");
        this.saveConfig("skills/power_progression.yml");
        this.saveConfig("skills/smithing.yml");
        this.saveConfig("skills/smithing_progression.yml");
        this.saveConfig("skills/woodcutting.yml");
        this.saveConfig("skills/woodcutting_progression.yml");
        TranslationManager.load(lang);
        if (!this.setupNMS()) {
            enabled = false;
            return;
        }
        if (usingPaperMC) {
            this.setupPaper();
        }
        ResourceExpenseRegistry.registerDefaultExpenses();
        UnlockConditionRegistry.registerDefaultConditions();
        ValhallaMMO.registerHook(new VaultHook());
        ValhallaMMO.registerHook(new PAPIHook());
        ValhallaMMO.registerHook(new WorldGuardHook());
        ValhallaMMO.registerHook(new JustLootItHook());
        ValhallaMMO.registerHook(new DecentHologramsHook());
        ValhallaMMO.registerHook(new NexoHook());
        ValhallaMMO.registerHook(new CoreProtectHook());
        ValhallaMMO.registerHook(new MythicMobsHook());
        ValhallaMMO.registerHook(new LootinHook());
    }

    public void onEnable() {
        if (pluginConfig.getBoolean("check_updates")) {
            UpdateChecker.checkUpdate();
        }
        if (!enabled) {
            ValhallaMMO.logSevere("This version of Minecraft is not compatible with ValhallaMMO. Sorry!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        nms.onEnable();
        resourcePackConfigForced = pluginConfig.getBoolean("resource_pack_config_override");
        this.saveAndUpdateConfig("gui_details.yml");
        customMiningSystem = pluginConfig.getBoolean("custom_mining_speeds", true);
        if (customMiningSystem) {
            packetListener = new PacketListener(new BlockBreakNetworkHandlerImpl());
            packetListener.addAll();
            this.registerListener(new CustomBreakSpeedListener());
            this.registerListener(packetListener);
        }
        ValhallaMMO.logInfo("NMS version " + nms.getClass().getSimpleName() + " registered!");
        if (paper != null) {
            ValhallaMMO.logInfo("Successfully hooked to paper version " + paper.getClass().getSimpleName());
        } else if (usingPaperMC && MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_4)) {
            ValhallaMMO.logWarning("Using papermc, but couldn't hook to paper API");
        }
        ResourcePack.tryStart();
        ProfileRegistry.setupDatabase();
        ProfileRegistry.registerDefaultProfiles();
        ItemAttributesRegistry.registerAttributes();
        PotionEffectRegistry.registerEffects();
        SmithingItemPropertyManager.loadConfig();
        AlchemyItemPropertyManager.loadConfig();
        GlobalEffect.loadActiveGlobalEffects();
        MonsterScalingManager.loadMonsterScalings();
        SkillRegistry.registerSkills();
        PartyManager.loadParties();
        BlockInteractConversions.loadConversions();
        ModifierScalingPresets.loadScalings();
        ProfilePersistence connection = ProfileRegistry.getPersistence();
        if (ConfigManager.getConfig("config.yml").get().getBoolean("metrics", true)) {
            Metrics metrics = new Metrics(this, 14942);
            metrics.addCustomChart(new Metrics.SimplePie("using_database_for_player_data", () -> connection.getClass().getSimpleName()));
            metrics.addCustomChart(new Metrics.SimplePie("premium_users", () -> "No"));
        }
        this.registerListener(new Dummy());
        PlayerJumpEvent.register(this);
        this.registerListener(new AnvilListener());
        this.registerListener(new ArmorSwitchListener());
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) && !customMiningSystem) {
            this.registerListener(new BlockDamageListener());
        }
        this.registerListener(new BlockListener());
        this.registerListener(new BrewingStandListener());
        this.registerListener(new CauldronCraftingListener());
        this.registerListener(new ChatListener());
        this.registerListener(new CookingListener());
        this.registerListener(new CraftingTableListener());
        this.registerListener(new DeathListener());
        this.registerListener(new EnchantmentListener());
        this.registerListener(new EntityAttackListener());
        this.registerListener(new EntityDamagedListener());
        this.registerListener(new EntityResponsibilityListener());
        this.registerListener(new EntitySpawnListener());
        this.registerListener(new HandSwitchListener());
        this.registerListener(new HealthRegenerationListener());
        this.registerListener(new ImmersiveRecipeListener());
        this.registerListener(new InteractListener());
        this.registerListener(new ItemConsumptionListener());
        this.registerListener(new ItemDamageListener());
        this.registerListener(new JoinLeaveListener());
        if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_2)) {
            this.registerListener(new JumpListener());
        }
        this.registerListener(new LootListener());
        this.registerListener(new MenuListener());
        this.registerListener(new MovementListener());
        this.registerListener(new PotionEffectListener());
        this.registerListener(new ProjectileListener());
        if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
            this.registerListener(new ReachAttackListener());
        }
        this.registerListener(new RecipeDiscoveryListener());
        this.registerListener(new SmithingTableListener());
        this.registerListener(new WorldSaveListener());
        this.registerListener(new BlockHardnessStick());
        this.registerCommand((CommandExecutor)new CommandManager(), "valhalla");
        this.registerCommand(new SkillsCommand(), "skills");
        this.registerCommand((CommandExecutor)new RedeemCommand(), "redeem");
        this.registerCommand((CommandExecutor)new LeaderboardCommand(), "valtop");
        this.registerCommand((CommandExecutor)new PartyCommand(), "party");
        this.registerCommand((CommandExecutor)new PartyManagementCommand(), "parties");
        this.registerCommand(new PartyChatCommand(), "partychat");
        this.registerCommand(new PartySpyCommand(), "partyspy");
        this.registerCommand(new ProfileCommand(PowerProfile.class), "power");
        this.registerCommand(new ProfileCommand(SmithingProfile.class), "smithing");
        this.registerCommand(new ProfileCommand(AlchemyProfile.class), "alchemy");
        this.registerCommand(new ProfileCommand(EnchantingProfile.class), "enchanting");
        this.registerCommand(new ProfileCommand(LightWeaponsProfile.class), "lightweapons");
        this.registerCommand(new ProfileCommand(HeavyWeaponsProfile.class), "heavyweapons");
        this.registerCommand(new ProfileCommand(ArcheryProfile.class), "archery");
        this.registerCommand(new ProfileCommand(LightArmorProfile.class), "lightarmor");
        this.registerCommand(new ProfileCommand(HeavyArmorProfile.class), "heavyarmor");
        this.registerCommand(new ProfileCommand(MiningProfile.class), "mining");
        this.registerCommand(new ProfileCommand(FarmingProfile.class), "farming");
        this.registerCommand(new ProfileCommand(WoodcuttingProfile.class), "woodcutting");
        this.registerCommand(new ProfileCommand(DiggingProfile.class), "digging");
        this.registerCommand(new ProfileCommand(FishingProfile.class), "fishing");
        LeaderboardManager.loadFile();
        CustomRecipeRegistry.loadFiles();
        LootTableRegistry.loadFiles();
        ArmorSetRegistry.loadFromFile(new File(ValhallaMMO.getInstance().getDataFolder(), "/armor_sets.json"));
        CustomItemRegistry.loadFromFile(new File(ValhallaMMO.getInstance().getDataFolder(), "/items.json"));
        LeaderboardManager.refreshLeaderboards();
        for (Player p : this.getServer().getOnlinePlayers()) {
            ProfileRegistry.getPersistence().loadProfile(p.getUniqueId());
        }
        worldBlacklist.addAll(pluginConfig.getStringList("world_blacklist"));
        if (PotionEffectRegistry.getCustomEffectDisplay() != null) {
            PotionEffectRegistry.getCustomEffectDisplay().start();
        }
        ItemUtils.startProjectileRunnableCache();
        GlobalEffect.initializeRunnable();
        PermanentPotionEffects.initializeRunnable();
        if (AlphaToBetaConversionHandler.shouldConvert()) {
            ValhallaMMO.logInfo("Alpha files found and conversion enabled! Enabling data transfer from Alpha to Beta");
            this.registerListener(new AlphaToBetaConversionHandler());
        }
        for (PluginHook hook : activeHooks.values()) {
            hook.whenPresent();
        }
    }

    public void onDisable() {
        if (!enabled) {
            return;
        }
        disabling = true;
        ProfileRegistry.getPersistence().saveAllProfiles(false);
        ProfilePersistence profilePersistence = ProfileRegistry.getPersistence();
        if (profilePersistence instanceof Database) {
            Database database = (Database)((Object)profilePersistence);
            try {
                database.getConnection().close();
            }
            catch (SQLException ignored) {
                ValhallaMMO.logSevere("Could not close connection");
            }
        }
        for (Player p : this.getServer().getOnlinePlayers()) {
            EntityAttributeStats.removeStats((LivingEntity)p);
            CustomBreakSpeedListener.removeFatiguedPlayer(p);
        }
        CustomRecipeRegistry.saveRecipes(false);
        LootTableRegistry.saveAll();
        ArmorSetRegistry.saveArmorSets();
        CustomItemRegistry.saveItems();
        GlobalEffect.saveActiveGlobalEffects();
        PartyManager.saveParties();
        JumpListener.onServerStop();
        if (packetListener != null) {
            packetListener.closeAll();
        }
        Host.stop();
    }

    private boolean setupNMS() {
        try {
            String nmsVersion = MinecraftVersion.getServerVersion().getNmsVersion();
            if (nmsVersion == null) {
                return false;
            }
            Class<?> clazz = Class.forName("me.athlaeos.valhallammo.nms.NMS_" + nmsVersion);
            if (NMS.class.isAssignableFrom(clazz)) {
                nms = (NMS)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return nms != null;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setupPaper() {
        try {
            String paperVersion = MinecraftVersion.getServerVersion().getPaperVersion();
            if (paperVersion == null) {
                return;
            }
            Class<?> clazz = Class.forName("me.athlaeos.valhallammo.paper.Paper_" + paperVersion);
            if (Paper.class.isAssignableFrom(clazz)) {
                paper = (Paper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public static NMS getNms() {
        return nms;
    }

    private void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void registerListener(Listener listener, String configKey) {
        if (pluginConfig.getBoolean(configKey)) {
            this.registerListener(listener);
        }
    }

    private void registerCommand(CommandExecutor command, String cmd) {
        PluginCommand c = ValhallaMMO.getInstance().getCommand(cmd);
        if (c == null) {
            return;
        }
        c.setExecutor(command);
    }

    public YamlConfiguration saveConfig(String name) {
        this.save(name);
        return ConfigManager.saveConfig(name).get();
    }

    public void save(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }

    private void updateConfig(String name) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateConfig(String name, List<String> excludedSections) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, excludedSections);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private YamlConfiguration saveAndUpdateConfig(String config) {
        this.save(config);
        this.updateConfig(config);
        return this.saveConfig(config);
    }

    private YamlConfiguration saveAndUpdateConfig(String config, List<String> excludedSections) {
        this.save(config);
        this.updateConfig(config, excludedSections);
        return this.saveConfig(config);
    }

    public static void logInfo(String message) {
        instance.getServer().getLogger().info("[ValhallaMMO] " + message);
    }

    public static void logWarning(String warning) {
        instance.getServer().getLogger().warning("[ValhallaMMO] " + warning);
    }

    public static void logFine(String warning) {
        instance.getServer().getLogger().fine("[ValhallaMMO] " + warning);
        Utils.sendMessage((CommandSender)instance.getServer().getConsoleSender(), "&a[ValhallaMMO] " + warning);
    }

    public static void logSevere(String help) {
        instance.getServer().getLogger().severe("[ValhallaMMO] " + help);
    }

    public static YamlConfiguration getPluginConfig() {
        return pluginConfig;
    }

    private static void registerHook(PluginHook hook) {
        if (hook.isPresent()) {
            activeHooks.put(hook.getClass(), hook);
            ValhallaMMO.logInfo("Initialized plugin hook with " + hook.getPlugin());
        }
    }

    public static boolean isHookFunctional(Class<? extends PluginHook> hook) {
        return activeHooks.containsKey(hook);
    }

    public static <T extends PluginHook> T getHook(Class<T> hook) {
        return (T)activeHooks.get(hook);
    }

    public static boolean isResourcePackConfigForced() {
        return resourcePackConfigForced;
    }

    public static void setResourcePackConfigForced(boolean resourcePackConfigForced) {
        ValhallaMMO.resourcePackConfigForced = resourcePackConfigForced;
    }

    public static boolean isWorldBlacklisted(String world) {
        return worldBlacklist.contains(world);
    }

    public static boolean isCustomMiningEnabled() {
        return customMiningSystem;
    }

    public static boolean isUsingPaperMC() {
        return usingPaperMC;
    }

    public static Paper getPaper() {
        return paper;
    }

    public static boolean isPremium() {
        return false;
    }

    public static boolean disabling() {
        return disabling;
    }

    static {
        resourcePackConfigForced = false;
        activeHooks = new HashMap<Class<? extends PluginHook>, PluginHook>();
        worldBlacklist = new HashSet<String>();
        usingPaperMC = Catch.catchOrElse(() -> {
            try {
                Class.forName("com.destroystokyo.paper.loottable.LootableInventory");
            }
            catch (ClassNotFoundException exception) {
                return false;
            }
            return true;
        }, false);
        enabled = true;
        disabling = false;
    }
}

