/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.animations.implementations;

import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ChargedShotActivation
extends Animation {
    private final Sound prefireSound;
    private final float prefireVolume;
    private final float prefirePitch;

    public ChargedShotActivation(String id) {
        super(id);
        YamlConfiguration config = ConfigManager.getConfig("skills/archery.yml").get();
        this.prefireSound = Utils.getSound(config.getString("charged_shot_prefire_sound"), null, "Invalid charged shot prefire sound given in skills/archery.yml charged_shot_prefire_sound");
        this.prefireVolume = (float)config.getDouble("charged_shot_prefire_sound_volume");
        this.prefirePitch = (float)config.getDouble("charged_shot_prefire_sound_pitch");
    }

    @Override
    public void animate(LivingEntity entity, Location location, Vector direction, int tick) {
        if (this.prefireSound != null) {
            entity.getWorld().playSound(location, this.prefireSound, this.prefireVolume, this.prefirePitch);
        }
    }
}

